/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.figures;

import com.bitctrl.lib.eclipse.emf.eclipse.model.EColor;
import com.bitctrl.lib.eclipse.emf.eclipse.model.EFont;
import com.bitctrl.lib.eclipse.emf.eclipse.model.HorizontalAlignment;
import com.bitctrl.lib.eclipse.emf.eclipse.model.VerticalAlignment;
import de.bsvrz.buv.plugin.doeditor.DoGraphics;
import de.bsvrz.buv.plugin.doeditor.editparts.DecoratorDatenSatz;
import de.bsvrz.buv.plugin.doeditor.figures.VisibleFormFigure;
import de.bsvrz.buv.plugin.doeditor.model.BackgroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BorderColorParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.BorderWidthParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.DrehwinkelParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.FontDataParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ForegroundParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.ParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.SichtbarkeitParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.StringParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.model.TextForm;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhalten;
import de.bsvrz.buv.plugin.doeditor.model.ZoomVerhaltenParameterDefinition;
import de.bsvrz.buv.plugin.doeditor.util.DoEditorUtil;
import de.bsvrz.buv.plugin.doeditor.util.PatternRegistry;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.themes.ColorUtil;

public class TextFormFigure
extends Label
implements VisibleFormFigure {
    private static final int TEXT_PADDING = 3;
    private final TextForm text;
    private final ResourceManager resourceManager;
    private final PatternRegistry patterns;
    private double scale = 1.0;
    private ZoomVerhalten zoomVerhalten;
    private RGB borderColor;
    private double borderWidth;
    private double currentAngle;

    public TextFormFigure(EditPartViewer viewer, TextForm text) {
        this.resourceManager = viewer.getResourceManager();
        this.text = text;
        this.zoomVerhalten = text.getZoomVerhalten();
        this.patterns = PatternRegistry.getRegistry(viewer);
    }

    @Override
    public void aktualisiereVomModel() {
        this.zoomVerhalten = this.text.getZoomVerhalten();
        this.setText(this.text.getText());
        this.setFont((Font)this.resourceManager.create((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)this.text.getFont().getFontData())));
        this.setLocation(this.text.getLocation());
        this.currentAngle = this.text.getAngle();
        this.updateSize();
        this.setForegroundColor(this.resourceManager.createColor(this.text.getForegroundColor().getRgb()));
        this.setBackgroundColor(this.resourceManager.createColor(this.text.getBackgroundColor().getRgb()));
        this.setOpaque(this.text.isFilled());
        this.setVisible(this.text.isVisible());
        this.borderWidth = this.text.getBorderWidth();
        this.borderColor = this.text.getBorderColor().getRgb();
    }

    @Override
    public void decorate(ParameterDefinition decorator, DecoratorDatenSatz datenSatz) {
        if (decorator instanceof ForegroundParameterDefinition) {
            ForegroundParameterDefinition foregroundDecorator = (ForegroundParameterDefinition)decorator;
            EColor startColor = foregroundDecorator.getStartColor();
            EColor endColor = foregroundDecorator.getEndColor();
            if (startColor != null) {
                RGB rgb = startColor.getRgb();
                if (endColor != null) {
                    rgb = ColorUtil.blend((RGB)rgb, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
                this.setForegroundColor(this.resourceManager.createColor(rgb));
            }
        } else if (decorator instanceof BackgroundParameterDefinition) {
            BackgroundParameterDefinition backgroundDecorator = (BackgroundParameterDefinition)decorator;
            EColor startColor = backgroundDecorator.getStartColor();
            EColor endColor = backgroundDecorator.getEndColor();
            if (startColor != null) {
                RGB rgb = startColor.getRgb();
                if (endColor != null) {
                    rgb = ColorUtil.blend((RGB)rgb, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
                this.setBackgroundColor(this.resourceManager.createColor(rgb));
            }
        } else if (decorator instanceof BorderColorParameterDefinition) {
            BorderColorParameterDefinition borderColorDecorator = (BorderColorParameterDefinition)decorator;
            EColor startColor = borderColorDecorator.getStartColor();
            EColor endColor = borderColorDecorator.getEndColor();
            if (startColor != null) {
                this.borderColor = startColor.getRgb();
                if (endColor != null) {
                    this.borderColor = ColorUtil.blend((RGB)this.borderColor, (RGB)endColor.getRgb(), (int)((int)datenSatz.getRelativerWert()));
                }
            }
        } else if (decorator instanceof BorderWidthParameterDefinition) {
            BorderWidthParameterDefinition borderWidthDecorator = (BorderWidthParameterDefinition)decorator;
            this.borderWidth = borderWidthDecorator.getStartWert();
            Float endWert = borderWidthDecorator.getEndWert();
            if (endWert != null) {
                this.borderWidth += ((double)endWert.floatValue() - this.borderWidth) * datenSatz.getRelativerWert() / 100.0;
            }
        } else if (decorator instanceof DrehwinkelParameterDefinition) {
            DrehwinkelParameterDefinition drehwinkelDecorator = (DrehwinkelParameterDefinition)decorator;
            float winkel = drehwinkelDecorator.getStartWinkel();
            Float endWinkel = drehwinkelDecorator.getEndWinkel();
            if (endWinkel != null) {
                winkel = (float)((double)winkel + (double)(endWinkel.floatValue() - winkel) * datenSatz.getRelativerWert() / 100.0);
            }
            this.currentAngle = winkel;
            this.updateSize();
        } else if (decorator instanceof FontDataParameterDefinition) {
            FontDataParameterDefinition fontDecorator = (FontDataParameterDefinition)decorator;
            EFont eFont = fontDecorator.getFont();
            if (eFont != null) {
                this.setFont((Font)this.resourceManager.create((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)eFont.getFontData())));
            }
        } else if (decorator instanceof SichtbarkeitParameterDefinition) {
            SichtbarkeitParameterDefinition sichtbarkeitsDecorator = (SichtbarkeitParameterDefinition)decorator;
            this.setVisible(sichtbarkeitsDecorator.isSichtbar());
        } else if (decorator instanceof StringParameterDefinition) {
            StringParameterDefinition stringDecorator = (StringParameterDefinition)decorator;
            String string = datenSatz.getTextWert();
            if (string == null) {
                string = stringDecorator.getString();
            }
            if (string != null) {
                this.setText(string);
            }
        } else if (decorator instanceof ZoomVerhaltenParameterDefinition) {
            ZoomVerhaltenParameterDefinition zoomDecorator = (ZoomVerhaltenParameterDefinition)decorator;
            this.zoomVerhalten = zoomDecorator.getZoomVerhalten();
            this.setScale(this.scale);
        }
    }

    public double getScale() {
        return this.scale;
    }

    protected Point getTextLocation() {
        int padding = 3;
        padding = (int)((double)padding + this.borderWidth * 2.0);
        HorizontalAlignment horizontal = this.text.getHorizontalAlignment();
        VerticalAlignment vertikal = this.text.getVerticalAlignment();
        Dimension textExtents = this.getTextUtilities().getTextExtents(this.text.getText(), (Font)this.resourceManager.create((DeviceResourceDescriptor)FontDescriptor.createFrom((FontData)this.text.getFont().getFontData())));
        textExtents.expand(padding * 2, padding * 2);
        Rectangle figureBounds = this.text.getBounds();
        int xPos = 0;
        int yPos = 0;
        xPos = switch (horizontal) {
            case HorizontalAlignment.CENTER -> figureBounds.width / 2 - textExtents.width / 2;
            case HorizontalAlignment.RIGHT -> figureBounds.width - textExtents.width;
            case HorizontalAlignment.LEFT -> 0;
            default -> 0;
        };
        yPos = switch (vertikal) {
            case VerticalAlignment.MIDDLE -> figureBounds.height / 2 - textExtents.height / 2;
            case VerticalAlignment.BOTTOM -> figureBounds.height - textExtents.height;
            case VerticalAlignment.TOP -> 0;
            default -> 0;
        };
        Point result = new Point(xPos + padding, yPos + padding);
        return result;
    }

    public void setScale(double scale) {
        this.scale = scale;
        this.updateSize();
    }

    private void updateSize() {
        Rectangle newBounds = DoEditorUtil.getCenterRotatedBounds(this.text.getBounds(), this.currentAngle);
        switch (this.zoomVerhalten) {
            case FIX: {
                newBounds.height = (int)((double)newBounds.height / this.scale);
                newBounds.width = (int)((double)newBounds.width / this.scale);
                break;
            }
            case VERTIKAL: {
                newBounds.width = (int)((double)newBounds.width / this.scale);
                break;
            }
            case HORIZONTAL: {
                newBounds.height = (int)((double)newBounds.height / this.scale);
                break;
            }
        }
        this.setBounds(newBounds);
    }

    public void paintFigure(Graphics gr) {
        DoGraphics graphics = new DoGraphics(gr);
        if (this.currentAngle != 0.0) {
            graphics.translate(this.getBounds().getCenter());
            graphics.rotate((float)this.currentAngle);
            graphics.translate(this.getBounds().getCenter().getNegated());
        }
        if (this.scale != 1.0) {
            graphics.translate(this.getBounds().getLocation());
            switch (this.zoomVerhalten) {
                case FIX: {
                    graphics.scale((float)(1.0 / this.scale), (float)(1.0 / this.scale));
                    break;
                }
                case HORIZONTAL: {
                    graphics.scale(1.0f, (float)(1.0 / this.scale));
                    break;
                }
                case VERTIKAL: {
                    graphics.scale((float)(1.0 / this.scale), 1.0f);
                    break;
                }
            }
            graphics.translate(this.getBounds().getLocation().getNegated());
        }
        Rectangle drawBounds = this.text.getBounds();
        if (this.isOpaque()) {
            Pattern pattern = this.patterns.getPattern(this.text.getBackgroundPattern(), this.getForegroundColor().getRGB(), this.getBackgroundColor().getRGB());
            if (pattern != null) {
                graphics.setBackgroundPattern(pattern);
            }
            graphics.fillRectangle(this.text.getBounds());
        }
        this.drawBorder((Graphics)graphics);
        graphics.translate(drawBounds.x, drawBounds.y);
        graphics.setForegroundColor(this.getForegroundColor());
        graphics.setAntialias(1);
        graphics.drawText(this.getSubStringText(), this.getTextLocation());
        graphics.translate(-drawBounds.x, -drawBounds.y);
        graphics.dispose();
    }

    protected void drawBorder(Graphics graphics) {
        double lineWidthFloat = this.borderWidth / this.scale;
        if (lineWidthFloat > 0.0) {
            double lineInset = Math.max(1.0, lineWidthFloat) / 2.0;
            int inset1 = (int)Math.floor(lineInset);
            int inset2 = (int)Math.ceil(lineInset);
            Rectangle r = Rectangle.SINGLETON.setBounds(this.text.getBounds());
            r.x += inset1;
            r.y += inset1;
            r.width -= inset1 + inset2;
            r.height -= inset1 + inset2;
            Color oldColor = graphics.getForegroundColor();
            float oldWidth = graphics.getLineWidthFloat();
            graphics.setForegroundColor(this.resourceManager.createColor(this.borderColor));
            graphics.setLineWidthFloat((float)lineWidthFloat);
            graphics.drawRectangle(r);
            graphics.setForegroundColor(oldColor);
            graphics.setLineWidthFloat(oldWidth);
        }
    }

    public String getSubStringText() {
        Object subStringText = this.getText();
        int widthShrink = this.getPreferredSize().width - this.text.getSize().width;
        if (widthShrink <= 0) {
            return subStringText;
        }
        Dimension effectiveSize = this.getTextSize().getExpanded(-widthShrink, 0);
        Font currentFont = this.getFont();
        int dotsWidth = this.getTextUtilities().getTextExtents((String)this.getTruncationString(), (Font)currentFont).width;
        if (effectiveSize.width < dotsWidth) {
            effectiveSize.width = dotsWidth;
        }
        int subStringLength = this.getTextUtilities().getLargestSubstringConfinedTo(this.text.getText(), currentFont, effectiveSize.width - dotsWidth);
        subStringText = this.text.getText().substring(0, subStringLength) + this.getTruncationString();
        return subStringText;
    }
}

