/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.util;

import de.bsvrz.buv.plugin.dobj.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.doeditor.model.EditorDoTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.Datensatz;
import de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellungsobjekteglobal.konfigurationsdaten.KdDarstellungsObjektTyp;
import de.bsvrz.sys.funclib.bitctrl.modell.tmdarstellungsobjekteglobal.objekte.DarstellungsObjektTyp;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public final class DoEditorUtil {
    private static final int MAX_LINELENGTH = 32000;

    public static EditorDoTyp konvertiere(DarstellungsObjektTyp typ) throws IOException {
        KdDarstellungsObjektTyp.Daten datum = (KdDarstellungsObjektTyp.Daten)typ.getKdDarstellungsObjektTyp().getDatum();
        StringBuilder definition = new StringBuilder();
        for (String line : datum.getDefinition()) {
            definition.append(line);
        }
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createURI((String)"/tmp"));
        ByteArrayInputStream stream = new ByteArrayInputStream(definition.toString().getBytes());
        resource.load((InputStream)stream, null);
        EList contents = resource.getContents();
        if (contents.size() != 1) {
            throw new IOException("Das Darstellungsobjekt konnte nicht gelesen werden!");
        }
        EditorDoTyp doTyp = (EditorDoTyp)contents.get(0);
        doTyp.setDoTypPid(typ.getPid());
        doTyp.setName(typ.getName());
        return doTyp;
    }

    public static KdDarstellungsObjektTyp.Daten konvertiere(EditorDoTyp modell) throws IOException {
        KdDarstellungsObjektTyp datensatz = new KdDarstellungsObjektTyp(null, RahmenwerkService.getService().getObjektFactory());
        KdDarstellungsObjektTyp.Daten result = new KdDarstellungsObjektTyp.Daten((Datensatz)datensatz, KdDarstellungsObjektTyp.Aspekte.Eigenschaften);
        ResourceSetImpl set = new ResourceSetImpl();
        Resource resource = set.createResource(URI.createFileURI((String)"/tmp"));
        resource.getContents().add((Object)modell);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        resource.save((OutputStream)stream, null);
        BufferedReader reader = new BufferedReader(new StringReader(stream.toString()));
        String line = null;
        StringBuilder buffer = new StringBuilder();
        do {
            if ((line = reader.readLine()) == null) continue;
            buffer.setLength(0);
            buffer.append(line);
            int start = 0;
            int end = Math.min(line.length(), 32000);
            while (start < line.length()) {
                result.getDefinition().add((Object)buffer.substring(start, end));
                start += 32000;
                end = Math.min(line.length(), end + 32000);
            }
        } while (line != null);
        return result;
    }

    public static Rectangle getCenterRotatedBounds(Rectangle baseBounds, double angle) {
        return DoEditorUtil.getRotatedBounds(baseBounds, angle, null);
    }

    public static Rectangle getRotatedBounds(Rectangle baseBounds, double angle, Point rotationPoint) {
        Point point = rotationPoint;
        if (point == null) {
            point = baseBounds.getCenter();
        }
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(angle), point.preciseX(), point.preciseY());
        Shape rect = new Rectangle2D.Double(baseBounds.preciseX(), baseBounds.preciseY(), baseBounds.preciseWidth(), baseBounds.preciseHeight());
        rect = transform.createTransformedShape(rect);
        java.awt.Rectangle b = rect.getBounds();
        return new Rectangle(b.x, b.y, b.width, b.height);
    }

    public static PointList getRotatedPoints(PointList basePoints, double angle, Point rotationPoint) {
        Point point = rotationPoint;
        if (point == null) {
            point = basePoints.getBounds().getCenter();
        }
        AffineTransform transform = new AffineTransform();
        transform.rotate(Math.toRadians(angle), point.preciseX(), point.preciseY());
        Shape poly = new Polygon();
        int idx = 0;
        while (idx < basePoints.size()) {
            Point pt = basePoints.getPoint(idx);
            ((Polygon)poly).addPoint(pt.x, pt.y);
            ++idx;
        }
        poly = transform.createTransformedShape(poly);
        PointList result = new PointList();
        PathIterator iterator = poly.getPathIterator(null);
        while (!iterator.isDone()) {
            double[] coords = new double[6];
            int type = iterator.currentSegment(coords);
            switch (type) {
                case 0: 
                case 1: {
                    result.addPoint((Point)new PrecisionPoint(coords[0], coords[1]));
                    break;
                }
            }
            iterator.next();
        }
        return result;
    }

    private DoEditorUtil() {
    }
}

