/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.doeditor.util;

import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AtlPortableBitMap;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.konfigurationsdaten.KdPortableBitMap;
import de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.objekte.PortableBitMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public final class PatternRegistry {
    private static final Map<EditPartViewer, PatternRegistry> REGISTRIES = new HashMap<EditPartViewer, PatternRegistry>();
    private final Map<PatternKey, Pattern> patterns = new HashMap<PatternKey, Pattern>();
    private final EditPartViewer editPartViewer;

    public static PatternRegistry getRegistry(EditPartViewer editPartViewer) {
        PatternRegistry result = REGISTRIES.get(editPartViewer);
        if (result == null) {
            result = new PatternRegistry(editPartViewer);
            REGISTRIES.put(editPartViewer, result);
        }
        return result;
    }

    private PatternRegistry(EditPartViewer editPartViewer) {
        this.editPartViewer = editPartViewer;
        editPartViewer.getControl().addDisposeListener(event -> {
            this.dispose();
            REGISTRIES.remove(editPartViewer);
        });
    }

    private void dispose() {
        for (Pattern pattern : this.patterns.values()) {
            pattern.dispose();
        }
        this.patterns.clear();
    }

    public Pattern getPattern(PortableBitMap pattern, RGB foreground, RGB background) {
        PatternKey key;
        Pattern result = null;
        if (pattern != null && (result = this.patterns.get(key = new PatternKey(pattern.getId(), foreground, background))) == null) {
            result = this.patternAnlegen(((KdPortableBitMap.Daten)pattern.getKdPortableBitMap().getDatum()).getBilddaten(), foreground, background);
            this.patterns.put(key, result);
        }
        return result;
    }

    private Pattern patternAnlegen(AtlPortableBitMap bildDaten, RGB color, RGB bkgd) {
        Pattern result = null;
        int xSize = 0;
        int ySize = 0;
        if (bildDaten.getAusmasse().getBreite() != null) {
            xSize = bildDaten.getAusmasse().getBreite().intValue();
        }
        if (bildDaten.getAusmasse().getHoehe() != null) {
            ySize = bildDaten.getAusmasse().getHoehe().intValue();
        }
        if (xSize > 0 && ySize > 0) {
            Display display = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay();
            Image image = new Image((Device)display, xSize, ySize);
            GC graphicsContext = new GC((Drawable)image);
            graphicsContext.setBackground(this.editPartViewer.getResourceManager().createColor(bkgd));
            graphicsContext.setForeground(this.editPartViewer.getResourceManager().createColor(color));
            graphicsContext.fillRectangle(0, 0, xSize, ySize);
            StringBuilder imagePattern = new StringBuilder();
            Object[] emptyStringArray = new String[]{};
            String[] stringArray = (String[])bildDaten.getMaske().toArray(emptyStringArray);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String zeile = stringArray[n2];
                imagePattern.append(zeile);
                ++n2;
            }
            int maxSize = Math.min(xSize * ySize, imagePattern.length());
            int zeile = 0;
            int spalte = 0;
            int idx = 0;
            while (idx < maxSize) {
                if (imagePattern.charAt(idx) == '1') {
                    graphicsContext.drawPoint(spalte, zeile);
                }
                if (++spalte >= xSize) {
                    spalte = 0;
                    ++zeile;
                }
                ++idx;
            }
            result = new Pattern((Device)display, image);
        }
        return result;
    }

    private class PatternKey {
        private final long objId;
        private final RGB foreground;
        private final RGB background;

        PatternKey(long objId, RGB foreground, RGB background) {
            this.objId = objId;
            this.foreground = foreground;
            this.background = background;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PatternKey other = (PatternKey)obj;
            return this.getOuterType().equals(other.getOuterType()) && Objects.equals(this.background, other.background) && Objects.equals(this.foreground, other.foreground) && this.objId == other.objId;
        }

        private PatternRegistry getOuterType() {
            return PatternRegistry.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.background == null ? 0 : this.background.hashCode());
            result = 31 * result + (this.foreground == null ? 0 : this.foreground.hashCode());
            result = 31 * result + (int)(this.objId ^ this.objId >>> 32);
            return result;
        }
    }
}

