/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.objfilter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.objfilter.interpreter.FehlerWert;

/**
 * Hilfsklasse zur Verwaltung eines Filterergebnisse in Kombination mit den bei
 * der Filterung aufgetretenen Fehlern.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public final class FilterErgebnis {

    /** Sammlung der vom Filter durchgelassenen Objekte. */
    private Collection<SystemObject> passiert = new LinkedHashSet<>();

    /** Sammlung der vom Filter augefilterten Objekte. */
    private Collection<SystemObject> ausgefiltert = new LinkedHashSet<>();

    /** Sammlung der aufgetretenen Fehler bei der Auswertung des Filters. */
    private Collection<FehlerWert> fehler = new ArrayList<>();

    public Collection<SystemObject> getPassiert() {
        return Collections.unmodifiableCollection(passiert);
    }

    public void addPassiert(SystemObject so) {
        this.passiert.add(so);
    }

    public void addPassiert(Collection<SystemObject> so) {
        this.passiert.addAll(so);
    }

    public Collection<SystemObject> getAusgefiltert() {
        return Collections.unmodifiableCollection(ausgefiltert);
    }

    public void addAusgefiltert(SystemObject so) {
        this.ausgefiltert.add(so);
    }

    public void addAusgefiltert(Collection<SystemObject> so) {
        this.ausgefiltert.addAll(so);
    }

    public Collection<FehlerWert> getFehler() {
        return Collections.unmodifiableCollection(fehler);
    }

    public void addFehler(FehlerWert fehlerWert) {
        this.fehler.add(fehlerWert);
    }

    public void addFehler(Collection<FehlerWert> fehlerWerte) {
        this.fehler.addAll(fehlerWerte);
    }

}
