/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Definition der Schnittstelle für ein Argument einer Operation eines
 * Filterausdrucks.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public interface Argument {

    /**
     * Die Funktion wertet das Argument aus und liefert das Ergebnis der Auswertung
     * als {@link Wert} zurück.
     *
     * Der {@link Wert} kann auch ein {@link FehlerWert} sein, wenn das Argument
     * nicht ausgewertet werden kann. In der übergebenen Fehlerliste, werden Fehler
     * bei der Auswertung gesammelt.
     *
     * @param obj    das Systemobjekt auf das der Filter momentan angewendet wird
     * @param errors eine Liste der Fehler, die bei der Auswertung befüllt werden
     *               kann.
     *
     * @return den bei der Auswertung des Arguments ermittelten Wert
     */
    Wert auswerten(SystemObject obj, List<FehlerWert> errors);

    /**
     * Die Funktion liefert die Klasse des bei der Auswertung des Arguments zu
     * erwartenden Datentyps.
     *
     * Wenn kein konkreter Datentyp ermittelt werden kann, weil der entsprechende
     * Kontext nicht zur Verfügung steht, wird die Klasse der Basisklasse
     * {@link Wert} geliefert.
     *
     * @return die Klasse des Ergebnistyps
     */
    Class<? extends Wert> getErgebnisTyp();

    /**
     * Gibt das Argument in lesbarer Form als Zeichenkette aus.
     *
     * @param level der Level für die Einrückung bei der Ausgabe
     * @return die Zeichenkette
     */
    String prettyPrint(int level);

    /**
     * Gibt das Argument in als Zeichenkette aus.
     *
     * @return die Zeichenkette
     */
    String print();
}
