/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Platzhalter für einen Wert, den die Auswertung eines Arguments oder einer
 * Operation liefert, wenn die Auswertung nicht wie gewünshct ausgeführt werden
 * konnte.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public final class FehlerWert implements Wert {

    /** die optionale PID, die bei der Ermittlung eines Wertes beteiligt war. */
    private String pid;

    /** die Fehlermeldung. */
    private String message;

    /** der Operator der der Operation in der der Fehler aufgetreten ist. */
    private Operator operator;

    /**
     * erzeugt einen Fehlerwert.
     *
     * @param operator der Operator der Operation in der der Fehler aufgetreten ist
     * @param obj      ein beteiligtes Systemobjekt
     * @param message  die Fehlermeldung
     */
    public FehlerWert(Operator operator, SystemObject obj, String message) {
        this.operator = operator;
        if (obj == null) {
            this.pid = "NONE";
        } else {
            this.pid = obj.getPid();
        }
        this.message = message;
    }

    /**
     * Hilfsfunktion zum erzeugen eines Fehlerwert, der optional in eine Fehlerliste
     * eingetragen wird.
     *
     * @param fehler   die optionale Fehlerliste
     * @param operator der Operator der Operation in der der Fehler aufgetreten ist
     * @param obj      ein beteiligtes Systemobjekt
     * @param message  die Fehlermeldung
     * @return der FehlerWert
     */
    public static FehlerWert fehler(List<FehlerWert> fehler, Operator operator, SystemObject obj, String message) {
        FehlerWert result = new FehlerWert(operator, obj, message);
        if (fehler != null) {
            fehler.add(result);
        }
        return result;
    }

    public String getMessage() {
        return message;
    }

    public String getPid() {
        return pid;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(operator == null ? "-" : operator.getBezeichnung());
        builder.append(':');
        builder.append(' ');
        builder.append(pid);
        builder.append(':');
        builder.append(' ');
        builder.append(message);
        return builder.toString();
    }

}
