/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

import de.bsvrz.dav.daf.main.Data.Array;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.objfilter.Filter;

/**
 * Repräsentation eines Feld-Attributes als {@link Wert}.
 *
 * Der Wert wird intern als Zwischenwert bei der Auswertung eines Filters
 * gebildet und sollte nicht für die Konstruktion eines Filters verwendet
 * werden.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class FeldWert implements Argument, Wert {

    /** das gekapselte Feld-Attribut. */
    private Array feld;

    public FeldWert(Array feld) {
        this.feld = feld;
    }

    @Override
    public final Array getFeld() {
        return feld;
    }

    @Override
    public final Class<? extends Wert> getErgebnisTyp() {
        return this.getClass();
    }

    @Override
    public final Wert auswerten(SystemObject obj, List<FehlerWert> errors) {
        return this;
    }

    @Override
    public final String prettyPrint(int level) {
        return Filter.printMargin(level) + print();
    }

    @Override
    public final String print() {
        return "array";
    }
}
