/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Operation, die die logische Negation zum übergebenen Argumentwert liefert.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class NichtOperation extends LogischeOperation {

    public NichtOperation(final Argument wert) {
        super(Operator.NICHT, Collections.singletonList(wert));
    }

    NichtOperation(List<Argument> argumente) {
        super(Operator.NICHT, argumente);
    }

    @Override
    public final Wert auswerten(final SystemObject obj, List<FehlerWert> errors) {

        final Optional<Boolean> status = getArgument(0).auswerten(obj, errors).getBool();
        if (status.isPresent()) {
            return new BoolWert(!status.get());
        }
        return FehlerWert.fehler(errors, getOperator(), obj, "Das erste Argument ist kein gültiger Boolwert");
    }

}
