/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Repräsentation eines Systemobjekts als {@link Wert}.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class SystemobjektWert implements Wert {

    /** das gekapselte Systemobjekt. */
    private final SystemObject systemObject;

    public SystemobjektWert(final SystemObject object) {
        systemObject = object;
    }

    @SuppressWarnings("unchecked")
    @Override
    public final int vergleiche(final Wert o) throws FilterException {
        if (o instanceof SystemobjektWert) {
            return systemObject.compareTo(o.getSystemObject());
        }

        throw new FilterException();
    }

    @Override
    public final SystemObject getSystemObject() {
        return systemObject;
    }
}
