/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.objfilter.interpreter;

/**
 * Repräsentation eines Fehlers bei der Verifizierung einer Filter-Instanz.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class VerifizierungsFehler {

    /** das Element bei dessen Prüfung der Fehler gefunden wurde. */
    private Object element;
    /** die Fehlermeldung. */
    private String fehlerText;

    /**
     * erstellt eine Istanz eines {@link VerifizierungsFehler}.
     *
     * @param element    das Element, bei dem der Fehler gefunden wurde
     * @param fehlerText die Fehlermeldung
     */
    public VerifizierungsFehler(Object element, String fehlerText) {
        this.element = element;
        this.fehlerText = fehlerText;
    }

    public final Object getElement() {
        return element;
    }

    public final String getFehlerText() {
        return fehlerText;
    }

    @Override
    public final String toString() {
        if (element instanceof Operation) {
            return ((Operation) element).getOperator().getBezeichnung() + ": " + fehlerText;
        }

        return fehlerText;
    }

}
