/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.Optional;

import de.bsvrz.dav.daf.main.Data.Array;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ObjectSet;
import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Schnittstelle zur Definition eines Wertsm der als Ergebnis der Auswertung
 * eines Arguments oder Operation an sich gebildet und weiterverarbeitet werden
 * kann.
 *
 * @author BitCtrl Sytems GmbH, Uwe Peuker
 */
public interface Wert {

    /**
     * liefert den Wert als Sytemobjekt.
     *
     * Die Standardimplementierung liefert null.
     *
     * @return ein Systemobjekt oder null
     */
    default SystemObject getSystemObject() {
        return null;
    }

    /**
     * liefert den Wert als Zeichenkette.
     *
     * Die Standardimplementierung liefert eine leere Zeichenkette.
     *
     * @return die Zeichenkette
     */
    default String getText() {
        return "";
    }

    /**
     * liefert den Wert als optionalen Boolean.
     *
     * Die Standardimplementierung liefert eine leeres Optional.
     *
     * @return die Zeichenkette
     */
    default Optional<Boolean> getBool() {
        return Optional.empty();
    }

    /**
     * liefert den Wert als Attributgruppe.
     *
     * Die Standardimplementierung liefert null.
     *
     * @return die Attributgruppe oder null
     */
    default AttributeGroup getAttributgruppe() {
        return null;
    }

    /**
     * liefert den Wert als Menge.
     *
     * Die Standardimplementierung liefert null.
     *
     * @return die Menge oder null
     */
    default ObjectSet getMenge() {
        return null;
    }

    /**
     * liefert den Wert als Zahl-Objekt
     *
     * Die Standardimplementierung liefert null.
     *
     * @return diZhl als Objekt oder null
     */
    default Number getZahl() {
        return null;
    }

    /**
     * liefert den Wert als {@link Array}.
     *
     * Die Standardimplementierung liefert null.
     *
     * @return das Array oder null
     */
    default Array getFeld() {
        return null;
    }

    /**
     * vergleicht einen Wert mit dem übergebenen.
     *
     * Die STandardimplementierung wirft eine {@link FilterException}
     *
     * @param other der Wert mit dem verglichen werden soll
     * @return -1, wenn der andere Wert größer ist, 0, wenn beide Werte gleich sind,
     *         1 sonst
     * @throws FilterException die Werte konnten nicht verglichen werden
     */
    default int vergleiche(final Wert other) throws FilterException {
        throw new FilterException();
    }
}
