/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.objfilter.Filter;

/**
 * Platzhalter für ein Argument, das (noch) nicht bestimmt werden konnte.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public class EmptyArgument implements Argument {

    /** Textrepräsenttion der Platzhalters für ein undefiniertes Argument. */
    private static final String EMPTY_ARGUMENT_LITERAL = "Undefiniert";

    @Override
    public final Wert auswerten(final SystemObject obj, List<FehlerWert> errors) {
        return FehlerWert.fehler(errors, null, obj, "Das Argumenttyp konnte nicht korrekt bestimmt werden");

    }

    @Override
    public final String prettyPrint(int level) {
        return Filter.printMargin(level) + EMPTY_ARGUMENT_LITERAL;
    }

    @Override
    public final String print() {
        return EMPTY_ARGUMENT_LITERAL;
    }

    @Override
    public final Class<? extends Wert> getErgebnisTyp() {
        return FehlerWert.class;
    }

    @Override
    public final String toString() {
        return print();
    }
}
