/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Operation, die prüft, ob ein Argument größer als ein zweites übergebenes
 * Argument ist.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class GroesserOperation extends VergleichsOperation {

    public GroesserOperation(final Argument links, Argument rechts) {
        super(Operator.GROESSER, links, rechts);
    }

    GroesserOperation(List<Argument> argumente) {
        super(Operator.GROESSER, argumente);
    }

    @Override
    public final Wert auswerten(final SystemObject obj, List<FehlerWert> errors) {
        try {
            return new BoolWert(
                    getArgument(0).auswerten(obj, errors).vergleiche(getArgument(1).auswerten(obj, errors)) > 0);
        } catch (final FilterException e) {
            return FehlerWert.fehler(errors, getOperator(), obj,
                    "Der Vergleich 'größer' der Argumente ist nicht möglich");
        }
    }

}
