package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

/**
 * Abstrakte logische Operation, die ein oder mehrere boolesche Argumente
 * verküpft.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public abstract class LogischeOperation extends Operation {

    public LogischeOperation(Operator operator, Argument[] argumente) {
        super(operator, argumente);
    }

    public LogischeOperation(Operator operator, List<Argument> argumente) {
        super(operator, argumente);
    }

    @Override
    public final Class<? extends Wert> getErgebnisTyp() {
        return BoolWert.class;
    }

    @Override
    public final boolean verifiziereArgumente(List<VerifizierungsFehler> fehler) {

        int idx = 1;
        for (Argument argument : getArgumente()) {
            if (argument.getErgebnisTyp() != BoolWert.class) {
                fehler.add(new VerifizierungsFehler(this, "Argument " + idx + " ist nicht vom Typ BOOL"));
            }
            idx++;
        }
        return fehler.isEmpty();
    }

    @Override
    public final boolean checkArgumentTyp(int idx, Class<? extends Wert> clazz) {
        return idx < getOperator().getArgCount() && (clazz == BoolWert.class || clazz == Wert.class);
    }
}
