/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

import de.bsvrz.dav.daf.main.config.SystemObject;

/**
 * Operation, die den Name des als Argument übergebenen Sytemobjekts liefert.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class NameOperation extends Operation {

    public NameOperation(final Argument objekt) {
        super(Operator.NAME, objekt);
    }

    NameOperation(List<Argument> argumente) {
        super(Operator.NAME, argumente);
    }

    @Override
    public final Wert auswerten(final SystemObject obj, List<FehlerWert> errors) {
        final SystemObject argObject = getArgument(0).auswerten(obj, errors).getSystemObject();
        if (argObject == null) {
            return FehlerWert.fehler(errors, getOperator(), obj, "Das erste Argument ist kein Systemobjekt");
        }
        return new TextWert(argObject.getName());
    }

    @Override
    public final Class<? extends Wert> getErgebnisTyp() {
        return TextWert.class;
    }

    @Override
    public final boolean verifiziereArgumente(List<VerifizierungsFehler> fehler) {

        if (getArgument(0).getErgebnisTyp() != SystemobjektWert.class) {
            fehler.add(new VerifizierungsFehler(this, "Argument 1 liefert kein Systemobjekt"));
        }
        return fehler.isEmpty();
    }

    @Override
    public final boolean checkArgumentTyp(int idx, Class<? extends Wert> clazz) {
        switch (idx) {
        case 0:
        case 1:
            return true;
        default:
            break;
        }
        return idx == 0 && (SystemobjektWert.class.isAssignableFrom(clazz) || clazz == Wert.class);
    }
}
