/*
 * SWE Funktionsbibliothek Objektfilter
 * Copyright (C) 2011-2020 BitCtrl Systems GmbH
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.objfilter.Filter;

/**
 * Repräsentation einer Zeichenkette als {@link Wert}.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 */
public class TextWert implements Wert, Argument {

    /** Zeichenkette mit Anführungszeichen, die potentiell entfernt werden soll. */
    private static final String QOUTE_STRING = "\"";

    /** die gekapselte Zeichenkette. */
    private String text;

    /**
     * Konstruktorm erzeugt eine Instanz eines {@link TextWert}, der die übergebene
     * Zeichenkette repräasentiert.
     *
     * @param text die Zeichenkette
     */
    public TextWert(final String text) {
        this.text = text.trim();
        if (this.text.startsWith(QOUTE_STRING)) {
            this.text = this.text.substring(1);
        }
        if (this.text.endsWith(QOUTE_STRING)) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
    }

    @Override
    public final String toString() {
        return '\"' + text + '\"';
    }

    @Override
    public final Wert auswerten(final SystemObject obj, List<FehlerWert> errors) {
        return this;
    }

    @Override
    public final int vergleiche(final Wert o) throws FilterException {
        if (o instanceof TextWert) {
            return text.compareTo(o.getText());
        }

        String otherText = o.getText();
        if (!otherText.isEmpty()) {
            return text.compareTo(otherText);
        }

        throw new FilterException();
    }

    @Override
    public final String getText() {
        return text;
    }

    @Override
    public final String prettyPrint(int level) {
        return Filter.printMargin(level) + '\"' + text + '\"';
    }

    @Override
    public final String print() {
        return '\"' + text + '\"';
    }

    @Override
    public final Class<? extends Wert> getErgebnisTyp() {
        return this.getClass();
    }
}
