package de.bsvrz.sys.funclib.objfilter.interpreter;

import java.util.List;

/**
 * Operation, die zwei Argumente miteinander vergleicht.
 *
 * @author BitCtrl Systems GmbH, Uwe Peuker
 *
 */
public abstract class VergleichsOperation extends Operation {

    public VergleichsOperation(Operator operator, List<Argument> argumente) {
        super(operator, argumente);
    }

    public VergleichsOperation(Operator operator, Argument links, Argument rechts) {
        super(operator, links, rechts);
    }

    @Override
    public final Class<? extends Wert> getErgebnisTyp() {
        return BoolWert.class;
    }

    @Override
    public final boolean verifiziereArgumente(List<VerifizierungsFehler> fehler) {

        if (getArgument(0).getErgebnisTyp().equals(FehlerWert.class)) {
            fehler.add(new VerifizierungsFehler(this, "Argument 1 ist nicht gültig"));
        }
        if (getArgument(1).getErgebnisTyp().equals(FehlerWert.class)) {
            fehler.add(new VerifizierungsFehler(this, "Argument 2 ist nicht gültig"));
        }
        return fehler.isEmpty();
    }

    @Override
    public final boolean checkArgumentTyp(int idx, Class<? extends Wert> clazz) {
        switch (idx) {
        case 0:
        case 1:
            return true;
        default:
            break;
        }
        return false;
    }

}
