/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.actions;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.darstellung.commands.CreateDarstellungsSpalteCommand;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.StilisierteDarstellung;
import de.bsvrz.buv.plugin.dopositionierer.util.DoPositioniererIcons;

/**
 * Action zum Anlegen einer neuen Darstellungsspalte in einer stilisierten
 * Darstellung.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class CreateDarstellungsSpalteAction extends WorkbenchPartAction {

	/**
	 * Initialisiert die Action.
	 *
	 * @param part
	 *            der Workbench Part für den die Action bestimmt ist.
	 */
	public CreateDarstellungsSpalteAction(final IWorkbenchPart part) {
		super(part);
		setText("Neue Darstellungsspalte anlegen");
		setImageDescriptor(DoPositioniererIcons.ActionAddDarstellungsspalte
				.getImageDescriptor());

		setToolTipText("Neue Darstellungsspalte anlegen");
		setId(DoPositioniererActionConstants.ERZEUGE_DARSTELLUNGSSPALTE);
		setActionDefinitionId(
				DoPositioniererActionConstants.ERZEUGE_DARSTELLUNGSSPALTE);
	}

	@Override
	protected boolean calculateEnabled() {
		final Command cmd = getCreateCommand();
		if (cmd != null) {
			return cmd.canExecute();
		}

		return false;
	}

	@Override
	public void run() {
		execute(getCreateCommand());
	}

	private Command getCreateCommand() {
		final Darstellung darstellung = getDarstellung();
		if (darstellung instanceof final StilisierteDarstellung stilisierteDarstellung) {
			return new CreateDarstellungsSpalteCommand(stilisierteDarstellung);
		}

		return UnexecutableCommand.INSTANCE;
	}

	private Darstellung getDarstellung() {
		return getWorkbenchPart().getAdapter(Darstellung.class);
	}

}
