/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;

import de.bsvrz.buv.plugin.darstellung.commands.DisableAutoVerwaltungCommand;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

public class DisableAutoVerwaltungAction extends WorkbenchPartAction {

	public DisableAutoVerwaltungAction(final IWorkbenchPart part) {
		super(part);
		setText("Automatische Verwaltung ausschalten");

		setToolTipText(
				"Schaltet die automatische Verwaltung durch die Auto-Ebene ab.");
		setId(DoPositioniererActionConstants.DISABLE_AUTO_VERWALTUNG);
	}

	@Override
	protected boolean calculateEnabled() {
		final Command cmd = getCommand();
		if (cmd != null) {
			return cmd.canExecute();
		}

		return false;
	}

	@Override
	public void run() {

		new UIJob("Automatische Verwaltung ausschalten") {

			@Override
			public IStatus runInUIThread(final IProgressMonitor monitor) {
				execute(getCommand());
				return Status.OK_STATUS;
			}
		}.schedule();

	}

	private Command getCommand() {
		final Darstellung darstellung = getWorkbenchPart()
				.getAdapter(Darstellung.class);
		if (darstellung == null) {
			return null;
		}

		final ISelection selection = getWorkbenchPart().getSite()
				.getSelectionProvider().getSelection();
		if (!selection.isEmpty()) {

			final Iterator iterator = ((IStructuredSelection) selection)
					.iterator();
			final Map<AutoEbene, List<DoModel>> selectedObjectMap = new HashMap<>();
			while (iterator.hasNext()) {
				final Object selected = iterator.next();
				if (selected instanceof final DoModelEditPart selectedEditPart
						&& ((DoModelEditPart<?, ?>) selected).getParent()
								.getModel() instanceof AutoEbene) {
					final AutoEbene ebene = (AutoEbene) selectedEditPart
							.getParent().getModel();
					if (!selectedObjectMap.containsKey(ebene)) {
						selectedObjectMap.put(ebene, new ArrayList<>());
					}
					selectedObjectMap.get(ebene)
							.add((DoModel) selectedEditPart.getModel());
				}
			}

			if (!selectedObjectMap.isEmpty()) {
				final CompoundCommand compoundCommand = new CompoundCommand();

				selectedObjectMap.entrySet().stream()
						.forEach(e -> compoundCommand.add(
								new DisableAutoVerwaltungCommand(e.getValue(),
										e.getKey())));

				return compoundCommand;
			}
		}

		return null;
	}
}
