/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.actions;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

import de.bsvrz.buv.plugin.darstellung.commands.EnableAutoVerwaltungCommand;
import de.bsvrz.buv.plugin.darstellung.model.AutoEbene;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.dobj.editparts.DoModelEditPart;
import de.bsvrz.buv.plugin.dobj.model.DoModel;

public class EnableAutoVerwaltungAction extends WorkbenchPartAction {

	public EnableAutoVerwaltungAction(final IWorkbenchPart part) {
		super(part);
		setText("Automatische Verwaltung einschalten");

		setToolTipText(
				"Schaltet die automatische Verwaltung durch die Auto-Ebene ab.");
		setId(DoPositioniererActionConstants.ENABLE_AUTO_VERWALTUNG);
	}

	@Override
	protected boolean calculateEnabled() {
		final Command cmd = getCreateCommand();
		if (cmd != null) {
			return cmd.canExecute();
		}

		return false;
	}

	@Override
	public void run() {
		execute(getCreateCommand());
	}

	private Command getCreateCommand() {
		final Darstellung darstellung = getWorkbenchPart()
				.getAdapter(Darstellung.class);
		if (darstellung == null) {
			return null;
		}

		final ISelection selection = getWorkbenchPart().getSite()
				.getSelectionProvider().getSelection();
		if (!selection.isEmpty()) {
			final Object selected = ((StructuredSelection) selection)
					.getFirstElement();

			if (selected instanceof DoModelEditPart
					&& ((DoModelEditPart<?, ?>) selected).getParent()
							.getModel() instanceof AutoEbene) {
				return new EnableAutoVerwaltungCommand(
						(DoModel) ((DoModelEditPart<?, ?>) selected).getModel(),
						(AutoEbene) ((DoModelEditPart<?, ?>) selected)
								.getParent().getModel());
			}
		}

		return null;
	}

}
