/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.editors;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.editors.EmfEinstellungenEditorInput;

/**
 * Editor Input für eine Darstellung. Eine Darstellung kann nur einmal geöffnet
 * werden.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DarstellungEditorInput extends EmfEinstellungenEditorInput {

	private final Darstellung darstellung;

	/**
	 * Initialisiert den Editor Input.
	 *
	 * @param darstellung
	 *            die zu bearbeitende Darstellung.
	 * @param einstellungsArt
	 *            die Einstellungsart unter der die Darstellung gespeichert
	 *            wird.
	 */
	public DarstellungEditorInput(final Darstellung darstellung,
			final SpeicherKey einstellungsArt) {
		super(darstellung, einstellungsArt);
		this.darstellung = darstellung;
	}

	@Override
	public boolean equals(final Object obj) {
		if (this == obj) {
			return true;
		} else if (obj instanceof final DarstellungEditorInput other) {
			return getEinstellungsArt().equals(other.getEinstellungsArt())
					&& darstellung.getName()
							.equals(other.darstellung.getName());
		}
		return false;
	}

	@Override
	public int hashCode() {
		return getEinstellungsArt().hashCode()
				^ darstellung.getName().hashCode();
	}

}
