/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.editors;

import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

import de.bsvrz.buv.plugin.darstellung.actions.EditEbeneAction;
import de.bsvrz.buv.plugin.darstellung.editparts.tree.DarstellungTreeEditPartFactory;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.dobj.util.DobjUtil;
import de.bsvrz.buv.plugin.dopositionierer.actions.CreateEbeneAction;
import de.bsvrz.buv.plugin.dopositionierer.actions.DoPositioniererActionConstants;

/**
 * Editor für die maßstäbliche Darstellung.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 */
public class MassstaeblicheDarstellungEditor
		extends AbstractDarstellungEditor<MassstaeblicheDarstellung> {

	/** Die ID des Editors. */
	public static final String EDITOR_ID = MassstaeblicheDarstellungEditor.class
			.getName();

	/**
	 * Initialisiert den Editor.
	 */
	public MassstaeblicheDarstellungEditor() {
		super(MassstaeblicheDarstellung.class);
	}

	@Override
	protected IContentOutlinePage getOutlinePage() {
		return new OutlinePage() {

			private EditEbeneAction editEbeneAction;

			{
				setMaxBufferSize(100000);
			}

			@Override
			protected EditPartFactory getEditPartFactory() {
				return new DarstellungTreeEditPartFactory();
			}

			@Override
			public void init(final IPageSite pageSite) {
				super.init(pageSite);

				final ActionRegistry registry = getActionRegistry();
				final IActionBars bars = pageSite.getActionBars();
				final IToolBarManager toolBarManager = bars.getToolBarManager();

				toolBarManager.add(registry.getAction(
						DoPositioniererActionConstants.ERZEUGE_EBENE));
			}

			@Override
			protected void configureOutlineViewer() {
				super.configureOutlineViewer();

				getTreeViewer().setProperty(DobjUtil.PROP_EDITOR,
						getGraphicalViewer().getProperty(DobjUtil.PROP_EDITOR));
				getTreeViewer().setProperty(DobjUtil.PROP_EDITOR_TYPE,
						getGraphicalViewer()
								.getProperty(DobjUtil.PROP_EDITOR_TYPE));
			}

			@Override
			public void createControl(final Composite parent) {
				super.createControl(parent);
				editEbeneAction = new EditEbeneAction(getTreeViewer());
				getSite().getActionBars().getToolBarManager()
						.add(editEbeneAction);
			}

			@Override
			public void dispose() {
				getSite().getActionBars().getToolBarManager()
						.remove(editEbeneAction.getId());
				super.dispose();
			}

		};
	}

	@Override
	protected void configureGraphicalViewer() {
		super.configureGraphicalViewer();

		getActionRegistry().registerAction(new CreateEbeneAction(this));
	}

	@Override
	protected ContextMenuProvider createContextMenuProvider() {
		return new DoPositioniererContextMenuProvider(this,
				getGraphicalViewer(), getActionRegistry());
	}
}
