/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.internal;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.BundleContext;

import com.bitctrl.lib.eclipse.AbstractBitCtrlPlugin;

import de.bsvrz.buv.rw.basislib.einstellungen.RahmenwerkPreferenceStore;

/**
 * Das Plug-in <em>Vorpositionierer</em>.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DoPositioniererPlugin extends AbstractBitCtrlPlugin {

	/** Die ID des Plug-ins. */
	public static final String PLUGIN_ID = "de.bsvrz.buv.plugin.dopositionierer";

	private static DoPositioniererPlugin instance;

	/**
	 * Gibt die gemeinsame Instanz des Plug-ins zurück.
	 *
	 * @return das Plug-in oder <code>null</code>, wenn es nicht gestartet ist.
	 */
	public static DoPositioniererPlugin getDefault() {
		return instance;
	}

	private IPreferenceStore preferenceStore;

	@Override
	public void start(final BundleContext context) throws Exception {
		super.start(context);
		instance = this;
	}

	@Override
	public void stop(final BundleContext context) throws Exception {
		instance = null;
		super.stop(context);
	}

	/**
	 * liefert das durch den übergebenen String beschriebene Image oder null,
	 * wenn kein entsprechendes Image gefunden werden konnte.
	 *
	 * @param key
	 *            der String, der das Image definiert
	 * @return das Imag oder null
	 */
	public Image getImage(final String key) {
		Image image = getImageRegistry().get(key);
		if (image == null) {
			final ImageDescriptor desc = getDefault().getImageDescriptor(key);
			if (desc != null) {
				image = desc.createImage();
				if (image != null) {
					getImageRegistry().put(key, image);
				}
			}
		}

		return image;
	}

	@Override
	public IPreferenceStore getPreferenceStore() {
		// Create the preference store lazily.
		if (preferenceStore == null) {
			preferenceStore = RahmenwerkPreferenceStore.BENUTZER_NETZWERKWEIT;
		}
		return preferenceStore;
	}
}
