/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.perspectives;

import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

import de.bsvrz.buv.plugin.darstellung.views.DarstellungenView;

/**
 * Die Standardperspektive für den Vorpositionierer.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class DoPositioniererPerspective implements IPerspectiveFactory {

	/** Die ID der Perspektive. */
	public static final String PERSPECTIVE_ID = DoPositioniererPerspective.class
			.getName();

	@Override
	public void createInitialLayout(final IPageLayout layout) {
		layout.setEditorAreaVisible(true);

		// Linke Seite
		layout.addView(DarstellungenView.VIEW_ID, IPageLayout.LEFT, 0.2f,
				layout.getEditorArea());
		layout.addView("org.eclipse.ui.views.ContentOutline",
				IPageLayout.BOTTOM, 0.33f, DarstellungenView.VIEW_ID);

		// Unten
		layout.addView("org.eclipse.ui.views.PropertySheet", IPageLayout.BOTTOM,
				0.7f, layout.getEditorArea());
	}

}
