/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.widgets.TextChangeHelper;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungsSpalte;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public class DarstellungsSpalteSection
		extends AbstractSection<DarstellungsSpalte> {

	private final TextChangeHelper textListener = new TextChangeHelper() {

		@Override
		public void textChanged(final Text text) {
			EStructuralFeature feature;
			Object value;

			if (text == widthText) {
				feature = DarstellungPackage.Literals.DARSTELLUNGS_SPALTE__WIDTH;
				value = Integer.valueOf(text.getText());
			} else {
				return;
			}

			final SetCommand cmd = new SetCommand(getElement(), feature, value);
			getCommandStack().execute(cmd);
		}

	};

	private Button visibleCheckBox;
	private Text widthText;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createVisible(container);
		createWidth(container);
	}

	private void createVisible(final Composite composite) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;

		visibleCheckBox = factory.createButton(composite, "Sichtbar",
				SWT.CHECK);
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		visibleCheckBox.setLayoutData(data);

		visibleCheckBox.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final EStructuralFeature feature = DarstellungPackage.Literals.EBENE__VISIBLE;
				final Object value = visibleCheckBox.getSelection();
				final SetCommand cmd = new SetCommand(getElement(), feature,
						value);
				getCommandStack().execute(cmd);
			}

		});
	}

	private void createWidth(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;

		widthText = factory.createText(parent, "");
		data = new FormData();
		data.left = new FormAttachment(0, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(visibleCheckBox,
				ITabbedPropertyConstants.VSPACE);
		widthText.setLayoutData(data);

		final CLabel label = factory.createCLabel(parent, "Breite:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(widthText,
				-ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(widthText, 0, SWT.CENTER);
		label.setLayoutData(data);

		textListener.startListeningTo(widthText);
	}

	@Override
	public void refresh() {
		visibleCheckBox.setSelection(getElement().isVisible());

		textListener.startNonUserChange();
		try {
			final int width = getElement().getWidth();
			if (width > 0) {
				widthText.setText(String.valueOf(width));
			} else {
				widthText.setText("");
			}
		} finally {
			textListener.finishNonUserChange();
		}
	}

}
