/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

/**
 * Tabbed Property Section für eine {@link Ebene}.
 *
 * <p>
 * Bearbeitbar sind die folgenden Eingenschaften:
 * <ul>
 * <li>Sichtbarkeit</li>
 * </ul>
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class EbeneSection extends AbstractSection<Ebene> {

	private final class SichtbarSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final EStructuralFeature feature;
			final Object value;

			if (e.widget == visibleCheckBox) {
				feature = DarstellungPackage.Literals.EBENE__VISIBLE;
				value = visibleCheckBox.getSelection();
			} else {
				return;
			}

			final SetCommand cmd = new SetCommand(getElement(), feature, value);
			getCommandStack().execute(cmd);
		}
	}

	private final class AusblendbarSelectionAdapter extends SelectionAdapter {
		@Override
		public void widgetSelected(final SelectionEvent e) {
			final EStructuralFeature feature;
			final Object value;

			if (e.widget == ausblendbarCheckBox) {
				feature = DarstellungPackage.Literals.EBENE__AUSBLENDBAR;
				value = ausblendbarCheckBox.getSelection();
			} else {
				return;
			}

			final SetCommand cmd = new SetCommand(getElement(), feature, value);
			getCommandStack().execute(cmd);
		}
	}

	private Button visibleCheckBox;
	private Button ausblendbarCheckBox;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createVisible(container);
	}

	private void createVisible(final Composite composite) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		visibleCheckBox = factory.createButton(composite, "Sichtbar",
				SWT.CHECK);
		final FormData dataVisisble = new FormData();
		dataVisisble.left = new FormAttachment(0, 0);
		dataVisisble.right = new FormAttachment(100, 0);
		dataVisisble.top = new FormAttachment(0,
				ITabbedPropertyConstants.VSPACE);
		visibleCheckBox.setLayoutData(dataVisisble);

		visibleCheckBox.addSelectionListener(new SichtbarSelectionAdapter());

		ausblendbarCheckBox = factory.createButton(composite, "Ausblendbar",
				SWT.CHECK);
		final FormData dataAusblendbar = new FormData();
		dataAusblendbar.left = new FormAttachment(0, 0);
		dataAusblendbar.right = new FormAttachment(100, 0);
		dataAusblendbar.top = new FormAttachment(visibleCheckBox,
				ITabbedPropertyConstants.VSPACE, SWT.BOTTOM);
		ausblendbarCheckBox.setLayoutData(dataAusblendbar);
		ausblendbarCheckBox
				.addSelectionListener(new AusblendbarSelectionAdapter());
	}

	@Override
	public void refresh() {
		visibleCheckBox.setSelection(getElement().isVisible());
		ausblendbarCheckBox.setSelection(getElement().isAusblendbar());
	}

}
