/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.widgets.TextChangeHelper;

import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.darstellung.model.MassstaeblicheDarstellung;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

public class MassstaeblicheDarstellungSection
		extends AbstractSection<MassstaeblicheDarstellung> {

	private final TextChangeHelper textListener = new TextChangeHelper() {

		@Override
		public void textChanged(final Text text) {
			final EStructuralFeature feature;
			final Object value;

			if (text == minBreiteText) {
				feature = DarstellungPackage.Literals.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_BREITE;
				value = Double.valueOf(text.getText());
			} else if (text == maxBreiteText) {
				feature = DarstellungPackage.Literals.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_BREITE;
				value = Double.valueOf(text.getText());
			} else if (text == minLaengeText) {
				feature = DarstellungPackage.Literals.MASSSTAEBLICHE_DARSTELLUNG__MINIMALE_GEOGRAPHISCHE_LAENGE;
				value = Double.valueOf(text.getText());
			} else if (text == maxLaengeText) {
				feature = DarstellungPackage.Literals.MASSSTAEBLICHE_DARSTELLUNG__MAXIMALE_GEOGRAPHISCHE_LAENGE;
				value = Double.valueOf(text.getText());
			} else {
				return;
			}

			final SetCommand cmd = new SetCommand(getElement(), feature, value);
			getCommandStack().execute(cmd);
		}

	};

	private Text minBreiteText;
	private Text maxBreiteText;
	private Text maxLaengeText;
	private Text minLaengeText;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createBreite(container);
		createLaenge(container);
	}

	private void createBreite(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;
		CLabel label;

		minBreiteText = factory.createText(parent, "");
		data = new FormData();
		data.left = new FormAttachment(0, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(50, 0);
		data.top = new FormAttachment(0, ITabbedPropertyConstants.VSPACE);
		minBreiteText.setLayoutData(data);

		label = factory.createCLabel(parent, "Min. geo. Breite:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(minBreiteText,
				-ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(minBreiteText, 0, SWT.CENTER);
		label.setLayoutData(data);

		maxBreiteText = factory.createText(parent, "");
		data = new FormData();
		data.left = new FormAttachment(minBreiteText, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(minBreiteText, 0, SWT.CENTER);
		maxBreiteText.setLayoutData(data);

		label = factory.createCLabel(parent, "Max. geo. Breite:");
		data = new FormData();
		data.left = new FormAttachment(50, ITabbedPropertyConstants.HSPACE);
		data.right = new FormAttachment(maxBreiteText,
				-ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(maxBreiteText, 0, SWT.CENTER);
		label.setLayoutData(data);

		textListener.startListeningTo(minBreiteText);
		textListener.startListeningTo(maxBreiteText);
	}

	private void createLaenge(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		FormData data;
		CLabel label;

		minLaengeText = factory.createText(parent, "");
		data = new FormData();
		data.left = new FormAttachment(0, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(50, 0);
		data.top = new FormAttachment(minBreiteText,
				ITabbedPropertyConstants.VSPACE);
		minLaengeText.setLayoutData(data);

		label = factory.createCLabel(parent, "Min. geo. Länge:");
		data = new FormData();
		data.left = new FormAttachment(0, 0);
		data.right = new FormAttachment(minLaengeText,
				-ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(minLaengeText, 0, SWT.CENTER);
		label.setLayoutData(data);

		maxLaengeText = factory.createText(parent, "");
		data = new FormData();
		data.left = new FormAttachment(minLaengeText, STANDARD_LABEL_WIDTH);
		data.right = new FormAttachment(100, 0);
		data.top = new FormAttachment(minLaengeText, 0, SWT.CENTER);
		maxLaengeText.setLayoutData(data);

		label = factory.createCLabel(parent, "Max. geo. Länge:");
		data = new FormData();
		data.left = new FormAttachment(50, ITabbedPropertyConstants.HSPACE);
		data.right = new FormAttachment(maxLaengeText,
				-ITabbedPropertyConstants.HSPACE);
		data.top = new FormAttachment(maxLaengeText, 0, SWT.CENTER);
		label.setLayoutData(data);

		textListener.startListeningTo(minLaengeText);
		textListener.startListeningTo(maxLaengeText);
	}

	@Override
	public void refresh() {
		textListener.startNonUserChange();
		try {
			minBreiteText.setText(String
					.valueOf(getElement().getMinimaleGeographischeBreite()));
			maxBreiteText.setText(String
					.valueOf(getElement().getMaximaleGeographischeBreite()));
			minLaengeText.setText(String
					.valueOf(getElement().getMinimaleGeographischeLaenge()));
			maxLaengeText.setText(String
					.valueOf(getElement().getMaximaleGeographischeLaenge()));
		} finally {
			textListener.finishNonUserChange();
		}
	}

}
