/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.buv.plugin.dopositionierer.properties;

import static org.eclipse.swt.SWT.BORDER;
import static org.eclipse.swt.SWT.CENTER;
import static org.eclipse.swt.SWT.CHECK;
import static org.eclipse.ui.views.properties.tabbed.ITabbedPropertyConstants.HSPACE;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.UnsetCommand;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.dobj.model.DoKomponente;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;

/**
 * Diese Property Section dient dem Einstellen der Linienstärke der
 * Verbindungslinien in einer Darstellung.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class VerbindungslinieStaerkeSection
		extends AbstractSection<Darstellung> {

	private Label linienstaerkeLabel;
	private Spinner linienstaerke;
	private Button linienstaerkeUseDefault;

	@Override
	public void createControls(final Composite parent,
			final TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);

		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();
		final Composite container = factory.createFlatFormComposite(parent);

		createLinienstaerke(container);
	}

	private void createLinienstaerke(final Composite parent) {
		final TabbedPropertySheetWidgetFactory factory = getWidgetFactory();

		// Widgets anlegen

		linienstaerkeLabel = factory.createLabel(parent, "Linienstärke:",
				BORDER);

		linienstaerke = new Spinner(parent, BORDER);
		linienstaerke.setMinimum(1);
		linienstaerke.setMaximum(100);
		linienstaerke.setIncrement(1);
		linienstaerke.setPageIncrement(10);
		factory.adapt(parent);

		linienstaerkeUseDefault = factory.createButton(parent,
				"Defaultwert verwenden", CHECK);

		// Widgets layouten

		final FormData data = new FormData();
		data.left = new FormAttachment(linienstaerkeLabel, HSPACE);
		data.width = 150;
		data.top = new FormAttachment(0, 0);
		linienstaerke.setLayoutData(data);

		final FormData labelData = new FormData();
		labelData.left = new FormAttachment(0, 0);
		labelData.width = STANDARD_LABEL_WIDTH;
		labelData.top = new FormAttachment(linienstaerke, 0, CENTER);
		linienstaerkeLabel.setLayoutData(labelData);

		final FormData useDefaultData = new FormData();
		useDefaultData.left = new FormAttachment(linienstaerke, 0, HSPACE);
		useDefaultData.top = new FormAttachment(linienstaerke, 0, CENTER);
		linienstaerkeUseDefault.setLayoutData(useDefaultData);

		// Listener anmelden

		linienstaerke.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				final int value = linienstaerke.getSelection();
				final SetCommand cmd = new SetCommand(getElement(),
						DarstellungPackage.Literals.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE,
						value);
				getCommandStack().execute(cmd);
			}

		});
		linienstaerkeUseDefault.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				if (linienstaerkeUseDefault.getSelection()) {
					final UnsetCommand cmd = new UnsetCommand(getElement(),
							DarstellungPackage.Literals.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE);
					getCommandStack().execute(cmd);
				} else {
					final int value = getElement().getVerbindungslinieStaerke();
					final SetCommand cmd = new SetCommand(getElement(),
							DarstellungPackage.Literals.DARSTELLUNG__VERBINDUNGSLINIE_STAERKE,
							value);
					getCommandStack().execute(cmd);
				}
			}

		});
	}

	@Override
	public void refresh() {
		setLinienstaerkeToWidget();
		disableLinienstaerkeIfNecessary();
	}

	private void setLinienstaerkeToWidget() {
		final boolean isChanged = linienstaerke.getSelection() != getElement()
				.getVerbindungslinieStaerke();
		if (isChanged) {
			linienstaerke
					.setSelection(getElement().getVerbindungslinieStaerke());
		}
	}

	private void disableLinienstaerkeIfNecessary() {
		final boolean isDoKomponente = getElement()
				.eContainer() instanceof DoKomponente;
		final boolean useDefault = !getElement().isSetVerbindungslinieStaerke();

		linienstaerkeUseDefault.setSelection(useDefault);

		final boolean enabled = !isDoKomponente && !useDefault;
		linienstaerke.setEnabled(enabled);
		linienstaerkeLabel.setEnabled(enabled);
		linienstaerkeUseDefault.setEnabled(!isDoKomponente);
	}

}
