/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.util;

import java.io.Serializable;
import java.util.Comparator;

import org.eclipse.core.runtime.Assert;

import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;

/**
 * Comparator für die Sortierung von Punkten {@link PunktXY} ihrem Hochwer (von
 * Süd nach Nord). Es werden nur die Breitengrade in WGS-84 (Y-Koordinaten)
 * miteinander verglichen.
 *
 * @author BitCtrl Systems GmbH, Falko Schumann
 *
 */
public class BetriebsKilometerComparator
		implements Comparator<Punkt>, Serializable {

	private static final long serialVersionUID = 1L;

	@Override
	public int compare(final Punkt p1, final Punkt p2) {
		final KdPunktLiegtAufLinienObjekt.Daten punktLiegtAufLinienObjektDaten1 = ((PunktLiegtAufLinienObjekt) p1)
				.getKdPunktLiegtAufLinienObjekt().getDatum();
		final StrassenSegment strassenSegment1 = (StrassenSegment) punktLiegtAufLinienObjektDaten1
				.getLinienReferenz();
		final Double offset1 = punktLiegtAufLinienObjektDaten1.getOffset()
				.getValue();

		final KdPunktLiegtAufLinienObjekt.Daten punktLiegtAufLinienObjektDaten2 = ((PunktLiegtAufLinienObjekt) p2)
				.getKdPunktLiegtAufLinienObjekt().getDatum();
		final StrassenSegment strassenSegment2 = (StrassenSegment) punktLiegtAufLinienObjektDaten2
				.getLinienReferenz();
		final Double offset2 = punktLiegtAufLinienObjektDaten2.getOffset()
				.getValue();

		Assert.isTrue(strassenSegment1.equals(strassenSegment2),
				"Zum Vergleich zweier Punkte auf einem Strassensegment müssen die Strassensegmente beider Punkte identisch sein.");
		return offset1.compareTo(offset2);
	}

}
