/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.util;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import de.bsvrz.buv.plugin.dopositionierer.internal.DoPositioniererPlugin;

/**
 * Stellt gemeinsam nutzbare Icons zur Verfügung.
 *
 * @author BitCtrl Systems GmbH, Schumann
 *
 */
public enum DoPositioniererIcons {

	// Icons für Actions

	/**
	 * Schaltfläche für Objekte nach Himmelsrichtung oder Betriebskilometer
	 * anordnen.
	 */
	ActionAufreihen("icons/16x16/actions/aufreihen.png"),

	/**
	 * Schaltfläche um einer Darstellung eine neue Ebene hinzuzufügen.
	 */
	ActionAddEbene("icons/16x16/actions/ebenen-add.png"),

	/**
	 * Schaltfläche um einer stilisierten Darstellung eine neue
	 * Darstellungsspalte hinzuzufügen.
	 */
	ActionAddDarstellungsspalte(
			"icons/16x16/actions/darstellungsspalten-add.gif"),

	;

	private final ImageDescriptor imageDescriptor;

	DoPositioniererIcons(final String imagePath) {
		imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(
				DoPositioniererPlugin.PLUGIN_ID, imagePath);
		if (imageDescriptor == null) {
			final String message = "Datei nicht gefunden: " + imagePath;
			DoPositioniererPlugin.getDefault().getLogger().error(message);
		}
	}

	/**
	 * Gibt den {@link ImageDescriptor} zurück.
	 */
	public ImageDescriptor getImageDescriptor() {
		return imageDescriptor;
	}

}
