/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjektComparator;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.konfigurationsdaten.KdStrassenSegment;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;

public class StrassenCache {

	public StrassenCache(final ObjektFactory objektFactory) {
		strassen = new HashMap<>();

		final List<StrassenSegment> strassensegmente = (List<StrassenSegment>) objektFactory
				.bestimmeModellobjekte(StrassenSegment.PID);
		for (final StrassenSegment ss : strassensegmente) {
			final KdStrassenSegment.Daten strassenSegmentDaten = ss
					.getKdStrassenSegment().getDatum();
			if (strassenSegmentDaten != null) {
				final Strasse strasse = strassenSegmentDaten
						.getGehoertZuStrasse();
				if (strasse != null) {
					if (!strassen.containsKey(strasse)) {
						strassen.put(strasse,
								new TreeSet<>(new SystemObjektComparator()));
					}

					strassen.get(strasse).add(ss);
				}
			}
		}
	}

	private final Map<Strasse, SortedSet<StrassenSegment>> strassen;

	Set<Strasse> getStrassen() {
		return strassen.keySet();
	}

	public SortedSet<StrassenSegment> getStrassenSegmente(
			final Strasse strasse) {
		return strassen.get(strasse);
	}

}
