/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;

import de.bsvrz.buv.plugin.dopositionierer.internal.RahmenwerkService;
import de.bsvrz.buv.plugin.dopositionierer.util.PunktSortierung;
import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY;

public class AufreihenOptionsWizardPage extends WizardPage {

	public static final String PROP_SYSTEM_OBJECT_TYPE = "systemObjectType";

	private final PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(
			this);

	private SystemObjectType systemObjectType;
	private PunktSortierung sortierung;
	private boolean imVerhaeltnis;

	public AufreihenOptionsWizardPage(final String pageName) {
		super(pageName);
		setTitle("Optionen");
		setDescription(
				"Hier legen Sie fest, wie die ausgewählten Objekte auf der Linie angeordnet werden sollen.");
	}

	public synchronized void addPropertyChangeListener(
			final PropertyChangeListener listener) {
		pcsDelegate.addPropertyChangeListener(listener);
	}

	public synchronized void removePropertyChangeListener(
			final PropertyChangeListener listener) {
		pcsDelegate.removePropertyChangeListener(listener);
	}

	protected synchronized void fireDoTypChanged() {
		pcsDelegate.firePropertyChange(PROP_SYSTEM_OBJECT_TYPE, null,
				getSystemObjectType());
	}

	@Override
	public void createControl(final Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(2, true));

		createSortierung(container);
		createVerhaeltnis(container);

		final Label information = new Label(container, SWT.WRAP);
		information.setLayoutData(GridDataFactory.fillDefaults()
				.grab(true, false).span(2, 1).create());
		information.setText(
				"""
						Abhängig von der Auswahl, können verschiedene Systemobjekte platziert werden.\s\
						Objekte mit WGS84-Kordinaten können nach ihren Koordinaten sortiert werden.\s\
						Objekte mit Referenz auf eine Straße mit Betriebskilometer können nach Betriebskilometern sortiert werden.""");

		setControl(container);
		updatePageComplete();
	}

	private void createSortierung(final Composite parent) {
		final Group container = new Group(parent, SWT.NONE);
		container.setLayoutData(GridDataFactory.fillDefaults().create());
		container.setText("Sortieren nach");
		container.setLayout(new GridLayout());

		final Button hochwertRadioButton = new Button(container, SWT.RADIO);
		hochwertRadioButton.setText("Hochwert / Süd-Nord / y-Koordinate");
		sortierung = PunktSortierung.Hochwert;
		hochwertRadioButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				sortierung = PunktSortierung.Hochwert;

				final SystemObjectType oldValue = systemObjectType;
				final ClientDavInterface dav = RahmenwerkService.getService()
						.getRahmenwerk().getDavVerbindung();
				final DataModel dataModel = dav.getDataModel();
				systemObjectType = dataModel.getType(PunktXY.PID);
				pcsDelegate.firePropertyChange(PROP_SYSTEM_OBJECT_TYPE,
						oldValue, systemObjectType);

				updatePageComplete();
			}

		});

		final Button rechtswertRadioButton = new Button(container, SWT.RADIO);
		rechtswertRadioButton.setText("Rechtswert / West-Ost / x-Koordinate");
		hochwertRadioButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				sortierung = PunktSortierung.Rechtswert;

				final SystemObjectType oldValue = systemObjectType;
				final ClientDavInterface dav = RahmenwerkService.getService()
						.getRahmenwerk().getDavVerbindung();
				final DataModel dataModel = dav.getDataModel();
				systemObjectType = dataModel.getType(PunktXY.PID);
				pcsDelegate.firePropertyChange(PROP_SYSTEM_OBJECT_TYPE,
						oldValue, systemObjectType);

				updatePageComplete();
			}

		});

		final Button betriebskilometerRadioButton = new Button(container,
				SWT.RADIO);
		betriebskilometerRadioButton.setText("nach Betriebskilometer");
		betriebskilometerRadioButton
				.addSelectionListener(new SelectionAdapter() {

					@Override
					public void widgetSelected(final SelectionEvent e) {
						sortierung = PunktSortierung.Betriebskilometer;

						final SystemObjectType oldValue = systemObjectType;
						final ClientDavInterface dav = RahmenwerkService
								.getService().getRahmenwerk()
								.getDavVerbindung();
						final DataModel dataModel = dav.getDataModel();
						systemObjectType = dataModel
								.getType(PunktLiegtAufLinienObjekt.PID);
						pcsDelegate.firePropertyChange(PROP_SYSTEM_OBJECT_TYPE,
								oldValue, systemObjectType);

						updatePageComplete();
					}
				});
	}

	private void createVerhaeltnis(final Composite parent) {
		final Group container = new Group(parent, SWT.NONE);
		container.setLayoutData(GridDataFactory.fillDefaults().create());
		container.setText("Verteilen nach Abstand");
		container.setLayout(new GridLayout());

		final Button imVerhaeltnisRadioButton = new Button(container,
				SWT.RADIO);
		imVerhaeltnisRadioButton.setText("im Verhältnis");
		imVerhaeltnisRadioButton.setSelection(true);
		imVerhaeltnis = true;
		imVerhaeltnisRadioButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				imVerhaeltnis = true;
				updatePageComplete();
			}

		});

		final Button gleichmaessigRadioButton = new Button(container,
				SWT.RADIO);
		gleichmaessigRadioButton.setText("gleichmäßig");
		gleichmaessigRadioButton.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(final SelectionEvent e) {
				imVerhaeltnis = false;
				updatePageComplete();
			}

		});
	}

	private void updatePageComplete() {
		boolean pageComplete = true;

		pageComplete &= systemObjectType != null;

		setPageComplete(pageComplete);
	}

	public SystemObjectType getSystemObjectType() {
		return systemObjectType;
	}

	public PunktSortierung getSortierung() {
		return sortierung;
	}

	public boolean isImVerhaeltnis() {
		return imVerhaeltnis;
	}

}
