/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

import com.bitctrl.lib.eclipse.emf.viewers.EmfLabelProvider;

import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dobj.util.DoTypenUtil;
import de.bsvrz.buv.plugin.dobj.viewers.DoTypenTreeContentProvider;
import de.bsvrz.dav.daf.main.config.SystemObjectType;

public class DoTypWizardPage extends WizardPage {

	public static final String PROP_DO_TYP = "doTyp";

	private final PropertyChangeSupport pcsDelegate = new PropertyChangeSupport(
			this);

	private TreeViewer viewer;

	private DoTyp doTyp;

	public DoTypWizardPage(final String pageName) {
		super(pageName);
		setTitle("Darstellungsobjekttyp");
		setDescription(
				"Bitte wählen Sie den zu verwendenden Darstellungsobjekttyp aus.");
		setPageComplete(false);
	}

	@Override
	public void createControl(final Composite parent) {
		viewer = new TreeViewer(parent, SWT.BORDER | SWT.SINGLE);
		viewer.getControl().setLayoutData(
				GridDataFactory.fillDefaults().grab(true, true).create());
		viewer.setLabelProvider(new EmfLabelProvider());
		viewer.setContentProvider(new DoTypenTreeContentProvider());

		viewer.addSelectionChangedListener(event -> {
			final IStructuredSelection selection = (IStructuredSelection) viewer
					.getSelection();
			if (!selection.isEmpty()
					&& selection.getFirstElement() instanceof final DoTyp typ) {
				doTyp = typ;
			} else {
				doTyp = null;
			}

			updatePageComplete();
			fireDoTypChanged();
		});

		setControl(viewer.getControl());
	}

	private void updatePageComplete() {
		boolean pageComplete = true;
		final IStructuredSelection selection = (IStructuredSelection) viewer
				.getSelection();

		pageComplete &= !selection.isEmpty();
		pageComplete &= doTyp != null;
		if (doTyp != null) {
			pageComplete &= doTyp.getSystemObjectType() != null;
		}

		setPageComplete(pageComplete);
	}

	/**
	 * Gibt den gewählten Darstellungsobjekttyp zurück.
	 *
	 * @return der Darstellungsobjekttyp oder <code>null</code>, wenn keiner
	 *         ausgewählt wurde.
	 */
	public DoTyp getDoTyp() {
		return doTyp;
	}

	public void setSystemObjectType(final SystemObjectType systemObjectType) {
		final List<DoTyp> doTypen = new ArrayList<>();

		if (systemObjectType != null) {
			for (final DoTyp e : DoTypenUtil.getDoTypen()) {
				if (e.getSystemObjectType() != null && e.getSystemObjectType()
						.inheritsFrom(systemObjectType)) {
					doTypen.add(e);
				}
			}
		}

		viewer.setInput(doTypen);
		updatePageComplete();
	}

	public synchronized void addPropertyChangeListener(
			final PropertyChangeListener listener) {
		pcsDelegate.addPropertyChangeListener(listener);
	}

	public synchronized void removePropertyChangeListener(
			final PropertyChangeListener listener) {
		pcsDelegate.removePropertyChangeListener(listener);
	}

	protected synchronized void fireDoTypChanged() {
		pcsDelegate.firePropertyChange(PROP_DO_TYP, null, doTyp);
	}

}
