/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import java.io.IOException;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.plugin.dopositionierer.editors.DarstellungEditorInput;
import de.bsvrz.buv.plugin.dopositionierer.internal.DarstellungsTyp;
import de.bsvrz.buv.plugin.dopositionierer.internal.DoPositioniererPlugin;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.EinstellungsArtWizardPage;

public class NewDarstellungWizard extends Wizard implements INewWizard {

	public static final String WIZARD_ID = NewDarstellungWizard.class.getName();

	private IWorkbench workbench;
	private NewDarstellungWizardPage darstellungPage;
	private EinstellungsArtWizardPage einstellungsArtWizardPage;

	@Override
	public void init(final IWorkbench workbench,
			final IStructuredSelection selection) {
		this.workbench = workbench;
	}

	@Override
	public void addPages() {
		darstellungPage = new NewDarstellungWizardPage(
				NewDarstellungWizardPage.class.getName());
		addPage(darstellungPage);

		einstellungsArtWizardPage = new EinstellungsArtWizardPage(
				EinstellungsArtWizardPage.class.getName());
		addPage(einstellungsArtWizardPage);
	}

	@Override
	public boolean performFinish() {
		final Darstellung darstellung = darstellungPage.getDarstellung();
		final SpeicherKey einstellungsArt = einstellungsArtWizardPage
				.getFirstEinstellungsArt();
		if (exists(darstellung, einstellungsArt) && !MessageDialog.openQuestion(getShell(),
					"Darstellung existiert bereits",
					"Es gibt bereits eine Darstellung mit dem Namen \""
							+ darstellung.getName()
							+ "\" im Einstellungsspeicher der Art \n"
							+ einstellungsArt + "\"."
							+ "\n\nSoll diese Darstellung überschrieben werden.")) {
				return false;
			}

		try {
			DarstellungenEinstellungen.INSTANCE.setModellEinstellungen(
					einstellungsArt, darstellung.getName(), darstellung);
			final DarstellungEditorInput input = new DarstellungEditorInput(
					darstellung, einstellungsArt);
			input.setExists(true);
			DarstellungsTyp.openEditor(input);
			return true;

		} catch (final UrlasserDialogAbgebrochenException ex) {
			// Bediener hat den Urlasserdialog abgebrochen, das ist
			// ein
			// normaler
			// Vorgang
		} catch (final IOException ex) {
			ErrorDialog.openError(
					PlatformUI.getWorkbench().getActiveWorkbenchWindow()
							.getShell(),
					"FEHLER", "Darstellung konnte nicht angelegt werden!",
					new Status(IStatus.ERROR, DoPositioniererPlugin.PLUGIN_ID,
							ex.getLocalizedMessage(), ex));
		}

		return false;
	}

	private boolean exists(final Darstellung darstellung,
			final SpeicherKey einstellungsArt) {
		return DarstellungenEinstellungen.INSTANCE.getModellEinstellungen(
				einstellungsArt, darstellung.getName()) != null;
	}

}
