/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.dopositionierer.internal.DarstellungsTyp;

public class NewDarstellungWizardPage extends WizardPage {

	private Text name;
	private ListViewer darstellungsArt;

	public NewDarstellungWizardPage(final String pageName) {
		super(pageName);

		setTitle("Neue Darstellung");
		setDescription(
				"Bitte geben Sie den Namen und die Art der neuen Darstellung an.");
		setPageComplete(false);
	}

	@Override
	public void createControl(final Composite parent) {
		final Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(2, false));

		Label label = new Label(container, SWT.NONE);
		label.setText("Name");
		name = new Text(container, SWT.BORDER);
		name.setLayoutData(GridDataFactory.swtDefaults()
				.align(SWT.FILL, SWT.CENTER).grab(true, false).create());

		label = new Label(container, SWT.NONE);
		label.setText("Art der Darstellung");
		label.setLayoutData(GridDataFactory.swtDefaults()
				.align(SWT.LEFT, SWT.TOP).create());
		darstellungsArt = new ListViewer(container,
				SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		darstellungsArt.getControl().setLayoutData(
				GridDataFactory.fillDefaults().grab(true, true).create());
		darstellungsArt.setContentProvider(new ArrayContentProvider());
		darstellungsArt.setLabelProvider(new LabelProvider());
		darstellungsArt.setInput(DarstellungsTyp.values());
		darstellungsArt.setSelection(
				new StructuredSelection(DarstellungsTyp.values()[0]));

		hookListeners();
		name.setFocus();
		setControl(container);
	}

	private void hookListeners() {
		name.addModifyListener(e -> updatePageComplete());

		darstellungsArt
				.addSelectionChangedListener(event -> updatePageComplete());
	}

	private void updatePageComplete() {
		boolean complete = true;

		complete &= !name.getText().isEmpty();
		complete &= !darstellungsArt.getSelection().isEmpty();

		setPageComplete(complete);
	}

	public Darstellung getDarstellung() {
		final IStructuredSelection selection = (IStructuredSelection) darstellungsArt
				.getSelection();
		final DarstellungsTyp typ = (DarstellungsTyp) selection
				.getFirstElement();
		final Darstellung darstellung = typ.create();
		darstellung.setName(name.getText());
		return darstellung;
	}

}
