/*
 * Rahmenwerk-Plug-in "Vorpositionierer"
 * Copyright (C) 2023 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;

import de.bsvrz.buv.plugin.dopositionierer.internal.RahmenwerkService;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.ObjektFactory;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjektComparator;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;

public class SystemObjectsWizardPage extends WizardPage {

	private TableViewer viewer;
	private final Set<SystemObjekt> systemObjekte = new HashSet<>();
	private SystemObjectType systemObjectType;

	public SystemObjectsWizardPage(final String pageName) {
		super(pageName);
		setTitle("Systemobjekte");
		setDescription("Bitte wählen Sie die anzuzeigenden Systemobjekte aus.");
		setPageComplete(false);
	}

	@Override
	public void createControl(final Composite parent) {
		viewer = new TableViewer(parent);
		viewer.getControl().setLayoutData(
				GridDataFactory.fillDefaults().grab(true, true).create());
		viewer.setLabelProvider(new LabelProvider());
		viewer.setContentProvider(ArrayContentProvider.getInstance());
		viewer.addSelectionChangedListener(event -> {
			systemObjekte.clear();
			if (!event.getSelection().isEmpty()
					&& event.getSelection() instanceof final IStructuredSelection selection) {
				for (final Object e : selection.toList()) {
					if (e instanceof final SystemObjekt sysobj) {
						systemObjekte.add(sysobj);
					}
				}
			}

			updatePageComplete();
		});

		setControl(viewer.getControl());
	}

	private void updatePageComplete() {
		boolean pageComplete = true;

		pageComplete &= !systemObjekte.isEmpty();

		setPageComplete(pageComplete);
	}

	public Set<SystemObjekt> getSystemObjekte() {
		return systemObjekte;
	}

	public void setSystemObjectType(final SystemObjectType systemObjectType) {
		this.systemObjectType = systemObjectType;
		final List<SystemObjekt> objekte = new ArrayList<>();

		if (systemObjectType != null) {
			final ObjektFactory objektFactory = RahmenwerkService.getService()
					.getObjektFactory();
			objekte.addAll(objektFactory
					.bestimmeModellobjekte(systemObjectType.getPid()));
			Collections.sort(objekte, new SystemObjektComparator());
		}

		viewer.setInput(objekte);
		updatePageComplete();
	}

	public void setStrassenSegment(final StrassenSegment strassenSegment) {
		final List<PunktLiegtAufLinienObjekt> objekte = new ArrayList<>();

		if (systemObjectType != null && strassenSegment != null) {
			final ObjektFactory objektFactory = RahmenwerkService.getService()
					.getObjektFactory();
			for (final SystemObjekt so : objektFactory
					.bestimmeModellobjekte(systemObjectType.getPid())) {
				final PunktLiegtAufLinienObjekt p = (PunktLiegtAufLinienObjekt) so;
				final KdPunktLiegtAufLinienObjekt.Daten punktLiegtAufLinienObjektDaten = p
						.getKdPunktLiegtAufLinienObjekt().getDatum();
				if (punktLiegtAufLinienObjektDaten != null
						&& strassenSegment.equals(punktLiegtAufLinienObjektDaten
								.getLinienReferenz())) {
					objekte.add(p);
				}
			}
			Collections.sort(objekte, new SystemObjektComparator());
		}

		viewer.setInput(objekte);
		updatePageComplete();
	}

}
