/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.actions;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.dopositionierer.editors.DarstellungEditorInput;
import de.bsvrz.buv.plugin.dopositionierer.internal.DarstellungsTyp;
import de.bsvrz.buv.plugin.dopositionierer.internal.DoPositioniererPlugin;
import de.bsvrz.buv.rw.basislib.einstellungen.EinstellungOwnerType;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.bitctrl.eclipse.util.RahmenwerkUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public class EditDarstellungAction
extends Action {
    private final IWorkbenchPart part;

    public EditDarstellungAction(IWorkbenchPart part) {
        super("Darstellung bearbeiten");
        this.setId("de.bsvrz.buv.plugin.dopositionierer.command.bearbeiteDarstellung");
        this.setActionDefinitionId("de.bsvrz.buv.plugin.dopositionierer.command.bearbeiteDarstellung");
        this.part = part;
    }

    public void run() {
        ITreeSelection selection = (ITreeSelection)this.part.getSite().getSelectionProvider().getSelection();
        TreePath[] treePathArray = selection.getPaths();
        int n = treePathArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            if (path.getLastSegment() instanceof Darstellung) {
                Darstellung darstellung = (Darstellung)path.getLastSegment();
                IStatus status = EmfUtil.validate((EObject)darstellung, (String)"de.bsvrz.buv.plugin.dopositionierer");
                IPreferenceStore preferenceStore = DoPositioniererPlugin.getDefault().getPreferenceStore();
                if (status.isOK() || preferenceStore.getBoolean("fehlerhafte.darstellungen.in.editor.laden")) {
                    SpeicherKey einstellungsArt = (SpeicherKey)path.getFirstSegment();
                    if (!RahmenwerkUtils.isAdmin() && einstellungsArt.getOwnerType() == EinstellungOwnerType.SYSTEM) {
                        MessageDialog.openInformation((Shell)this.part.getSite().getShell(), (String)"Hinweis", (String)("Sie k\u00f6nnen die Darstellung" + EmfUtil.getText((EObject)darstellung) + " nicht unter " + String.valueOf(einstellungsArt) + " bearbeiten, weil Sie nicht \u00fcber Administratorrechte verf\u00fcgen. Kopieren Sie die Darstellung und bearbeiten Sie sie dann."));
                    } else {
                        DarstellungEditorInput input = new DarstellungEditorInput(darstellung, einstellungsArt);
                        input.setExists(true);
                        DarstellungsTyp.openEditor((IEditorInput)input);
                    }
                } else {
                    ErrorDialog.openError((Shell)this.part.getSite().getShell(), (String)"Darstellung nicht darstellbar", (String)("Die Darstellung \"" + darstellung.getName() + "\" kann nicht ge\u00f6ffnet werden, weil sie nicht lesbar ist."), (IStatus)status);
                }
            }
            ++n2;
        }
    }
}

