/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.editors;

import com.bitctrl.lib.eclipse.emf.util.EmfUtil;
import de.bsvrz.buv.plugin.darstellung.editparts.DarstellungEditPartFactory;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.plugin.dobj.actions.ToggleOnlineAction;
import de.bsvrz.buv.plugin.dobj.editors.DobjGraphicalEditorWithPalette;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dopositionierer.editors.DarstellungEditorPaletteFactory;
import de.bsvrz.buv.plugin.dopositionierer.internal.DoPositioniererPlugin;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDarstellungEditor<T extends Darstellung>
extends DobjGraphicalEditorWithPalette<T> {
    private PaletteRoot paletteRoot;
    private SpeicherKey einstellungsArt;

    protected AbstractDarstellungEditor(Class<T> modelClass) {
        super(modelClass);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = new DarstellungEditorPaletteFactory().createPalette();
        }
        return this.paletteRoot;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.einstellungsArt = (SpeicherKey)input.getAdapter(SpeicherKey.class);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        List<Object> selectionList = ((IStructuredSelection)selection).toList().stream().filter(IAdaptable.class::isInstance).map(o -> ((IAdaptable)o).getAdapter(DoModel.class)).filter(o -> o != null).toList();
        List<EditPart> editParts = this.getGraphicalViewer().getEditPartRegistry().values().stream().filter(IAdaptable.class::isInstance).filter(o -> selectionList.contains(o.getAdapter(DoModel.class))).toList();
        if (!editParts.isEmpty() && !Objects.equals(part, (Object)this)) {
            this.getGraphicalViewer().setSelection((ISelection)new StructuredSelection(editParts));
        }
        super.selectionChanged(part, selection);
    }

    public String getContributorId() {
        return "de.bsvrz.buv.plugin.dopositionierer.propertyContributor";
    }

    protected EditPartFactory getEditPartFactory() {
        return new DarstellungEditPartFactory();
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().setProperty("de.bsvrz.buv.plugin.dobj.editor", (Object)true);
        this.getGraphicalViewer().setProperty("de.bsvrz.buv.plugin.dobj.editorType", (Object)2);
        super.configureGraphicalViewer();
        ActionRegistry registry = this.getActionRegistry();
        ToggleOnlineAction action = new ToggleOnlineAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
    }

    public void doSave(IProgressMonitor monitor) {
        Darstellung darstellung = (Darstellung)this.getModel();
        IStatus status = EmfUtil.validate((EObject)darstellung, (String)"de.bsvrz.buv.plugin.dopositionierer");
        if (status.getSeverity() != 0) {
            QuestionErrorDialog dialog = new QuestionErrorDialog(this.getSite().getShell(), "Darstellung kann nicht gespeichert werden.", "Die zu speichernde Darstellung ist ung\u00fcltig.\n\nM\u00f6chten Sie die Darstellung trotz der Fehler speichern?\n\nDabei w\u00fcrden die fehlenden Darstellungsobjekte ggf. aus der Darstellung entfernt. ", status, 7);
            DoPositioniererPlugin.getDefault().getLog().log(status);
            if (1 == dialog.open()) {
                return;
            }
        }
        try {
            DarstellungenEinstellungen.INSTANCE.setModellEinstellungen(this.einstellungsArt, darstellung.getName(), (EObject)darstellung);
            this.getCommandStack().markSaveLocation();
        }
        catch (UrlasserDialogAbgebrochenException dialog) {
        }
        catch (IOException ex) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"FEHLER", (String)"Darstellung konnte nicht gesichert werden!", (IStatus)new Status(4, "de.bsvrz.buv.plugin.dopositionierer", ex.getLocalizedMessage(), (Throwable)ex));
        }
    }

    public Object getAdapter(Class type) {
        if (type == Darstellung.class) {
            return this.getModel();
        }
        return super.getAdapter(type);
    }

    private static final class QuestionErrorDialog
    extends ErrorDialog {
        public QuestionErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
            this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
            this.createDetailsButton(parent);
        }

        protected void buttonPressed(int buttonId) {
            switch (buttonId) {
                case 2: {
                    this.setReturnCode(0);
                    this.close();
                    break;
                }
                case 3: {
                    this.setReturnCode(1);
                    this.close();
                    break;
                }
                default: {
                    super.buttonPressed(buttonId);
                }
            }
        }
    }
}

