/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.problems;

import com.bitctrl.lib.eclipse.emf.eclipse.model.Named;
import de.bsvrz.buv.plugin.darstellung.model.Ansicht;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungValidator;
import de.bsvrz.buv.plugin.darstellung.util.EObjectStatus;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dopositionierer.internal.DoPositioniererPlugin;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class ProblemsView
extends ViewPart {
    private TreeViewer viewer;
    private final IPartListenerImplementation partListener = new IPartListenerImplementation();
    private final ISelectionListenerImplementation selectionListenerImplementation = new ISelectionListenerImplementation();

    public void createPartControl(Composite parent) {
        Composite tableComposite = new Composite(parent, 0);
        TreeColumnLayout treeColumnLayout = new TreeColumnLayout();
        tableComposite.setLayout((Layout)treeColumnLayout);
        this.viewer = new TreeViewer(tableComposite, 66308);
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new StatusContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.createTypColumn(treeColumnLayout);
        this.createMeldungsColumn(treeColumnLayout);
        this.createDObjColumn(treeColumnLayout);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this.selectionListenerImplementation);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        Menu menu = menuManager.createContextMenu((Control)parent);
        this.viewer.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu(menuManager, (ISelectionProvider)this.viewer);
        this.getViewSite().getPage().addPartListener((IPartListener)this.partListener);
    }

    private void createMeldungsColumn(TreeColumnLayout treeColumnLayout) {
        TreeViewerColumn colPid = new TreeViewerColumn(this.viewer, 0);
        treeColumnLayout.setColumnData((Widget)colPid.getColumn(), (ColumnLayoutData)new ColumnWeightData(150, 200, true));
        colPid.getColumn().setText("Meldung");
        colPid.setLabelProvider((CellLabelProvider)new MeldungColumnLabelProvider());
    }

    private void createTypColumn(TreeColumnLayout treeColumnLayout) {
        TreeViewerColumn colName = new TreeViewerColumn(this.viewer, 0);
        treeColumnLayout.setColumnData((Widget)colName.getColumn(), (ColumnLayoutData)new ColumnWeightData(30, 100, true));
        colName.getColumn().setText("Typ");
        colName.setLabelProvider((CellLabelProvider)new TypColumnLabel());
    }

    private void createDObjColumn(TreeColumnLayout treeColumnLayout) {
        TreeViewerColumn colName = new TreeViewerColumn(this.viewer, 0);
        treeColumnLayout.setColumnData((Widget)colName.getColumn(), (ColumnLayoutData)new ColumnWeightData(100, 100, true));
        colName.getColumn().setText("Darstellungsobjekt-Typ");
        colName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof EObjectStatus) {
                    EObjectStatus status = (EObjectStatus)element;
                    EObject darstellungsObjekt = status.getModellObject();
                    if (darstellungsObjekt instanceof DoModel) {
                        DoModel doModel = (DoModel)darstellungsObjekt;
                        return doModel.getDoTyp().getName();
                    }
                    if (darstellungsObjekt instanceof Named) {
                        Named named = (Named)darstellungsObjekt;
                        return named.getName();
                    }
                }
                return "";
            }
        });
    }

    public void dispose() {
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this.selectionListenerImplementation);
        this.getViewSite().getPage().removePartListener((IPartListener)this.partListener);
        super.dispose();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private final class IPartListenerImplementation
    implements IPartListener {
        private IPartListenerImplementation() {
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
            Darstellung adapter = (Darstellung)part.getAdapter(Darstellung.class);
            if (adapter != null && ProblemsView.this.viewer != null && !ProblemsView.this.viewer.getControl().isDisposed()) {
                ProblemsView.this.viewer.getControl().getDisplay().asyncExec(() -> {
                    if (ProblemsView.this.viewer != null && !ProblemsView.this.viewer.getControl().isDisposed()) {
                        if (Objects.equals(ProblemsView.this.viewer.getInput(), adapter)) {
                            ProblemsView.this.viewer.refresh();
                        } else {
                            ProblemsView.this.viewer.setInput((Object)adapter);
                        }
                        ProblemsView.this.viewer.expandAll();
                    }
                });
            }
        }
    }

    private final class ISelectionListenerImplementation
    implements ISelectionListener {
        private ISelectionListenerImplementation() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            IStructuredSelection isel = (IStructuredSelection)selection;
            Object firstElement = isel.getFirstElement();
            if (firstElement instanceof Named) {
                if (Objects.equals(firstElement, ProblemsView.this.viewer.getInput())) {
                    ProblemsView.this.viewer.refresh();
                } else {
                    ProblemsView.this.viewer.setInput(firstElement);
                }
                ProblemsView.this.viewer.expandAll();
            }
        }
    }

    private static final class MeldungColumnLabelProvider
    extends ColumnLabelProvider {
        private MeldungColumnLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStatus) {
                IStatus status = (IStatus)element;
                return status.getMessage();
            }
            return super.getText(element);
        }
    }

    private static final class StatusContentProvider
    implements ITreeContentProvider {
        private StatusContentProvider() {
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Ansicht || inputElement instanceof Darstellung) {
                return DarstellungValidator.validiere((Named)((Named)inputElement)).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof MultiStatus) {
                return ((MultiStatus)parentElement).getChildren();
            }
            return new Object[0];
        }
    }

    private static final class TypColumnLabel
    extends ColumnLabelProvider {
        private TypColumnLabel() {
        }

        public String getText(Object element) {
            if (element instanceof IStatus) {
                IStatus status = (IStatus)element;
                return switch (status.getSeverity()) {
                    case 8 -> "Abgebrochen";
                    case 2 -> "Warnung";
                    case 1 -> "Information";
                    case 4 -> "Fehler";
                    default -> "Ok";
                };
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IStatus) {
                IStatus status = (IStatus)element;
                String key = "/icons/16x16/ok.gif";
                return switch (status.getSeverity()) {
                    case 8 -> {
                        key = "/icons/16x16/cancel.gif";
                        yield DoPositioniererPlugin.getDefault().getImage(key);
                    }
                    case 2 -> {
                        key = "/icons/16x16/warning.gif";
                        yield DoPositioniererPlugin.getDefault().getImage(key);
                    }
                    case 1 -> {
                        key = "/icons/16x16/info.gif";
                        yield DoPositioniererPlugin.getDefault().getImage(key);
                    }
                    case 4 -> {
                        key = "/icons/16x16/error.gif";
                        yield DoPositioniererPlugin.getDefault().getImage(key);
                    }
                    default -> DoPositioniererPlugin.getDefault().getImage(key);
                };
            }
            return super.getImage(element);
        }
    }
}

