/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.properties;

import com.bitctrl.lib.eclipse.emf.gef.commands.AddCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.RemoveCommand;
import com.bitctrl.lib.eclipse.emf.gef.commands.SetCommand;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.DarstellungPackage;
import de.bsvrz.buv.plugin.dobj.properties.AbstractSection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collection;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DarstellungZoomStufenSection
extends AbstractSection<Darstellung> {
    private static final NumberFormat FORMATER = new DecimalFormat("###.######");
    private TableViewer zoomStufenViewer;
    private Spinner skalierungSpinner;

    static {
        FORMATER.setMinimumFractionDigits(6);
        FORMATER.setMaximumFractionDigits(6);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Composite container = factory.createFlatFormComposite(parent);
        this.createZoomStufen(container);
        this.createSkalierung(container);
    }

    private void createZoomStufen(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        Table table = factory.createTable(parent, 2048);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(80, 0);
        data.top = new FormAttachment(0, 4);
        data.height = 50;
        table.setLayoutData((Object)data);
        this.zoomStufenViewer = new TableViewer(table);
        this.zoomStufenViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Double d = (Double)element;
                double skalierung = ((Darstellung)DarstellungZoomStufenSection.this.getElement()).getZoomSkalierung();
                return FORMATER.format(d) + " (" + Math.round(d * skalierung * 100.0) + "%)";
            }
        });
        this.zoomStufenViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        CLabel label = factory.createCLabel(parent, "Zoomstufen:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)table, -5);
        data.top = new FormAttachment((Control)table, 0, 128);
        label.setLayoutData((Object)data);
        Button addZoomStufeButton = factory.createButton(parent, "Hinzuf\u00fcgen", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)table, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)table, 0, 128);
        addZoomStufeButton.setLayoutData((Object)data);
        Button removeZoomStufeButton = factory.createButton(parent, "Entfernen", 8);
        removeZoomStufeButton.setEnabled(false);
        data = new FormData();
        data.left = new FormAttachment((Control)table, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)addZoomStufeButton, 4);
        removeZoomStufeButton.setLayoutData((Object)data);
        addZoomStufeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dlg = new InputDialog(DarstellungZoomStufenSection.this.getPart().getSite().getShell(), "Neue Zoomstufe", "Bitte geben Sie eine neue Zoomstufe (Double) ein.", "1.0", newText -> {
                    Double value;
                    try {
                        value = Double.valueOf(newText);
                    }
                    catch (NumberFormatException ex) {
                        return "Keine g\u00fcltige Zahl.";
                    }
                    if (((Darstellung)DarstellungZoomStufenSection.this.getElement()).getZoomStufen().contains((Object)value)) {
                        return "Die Zoomstufe ist bereits vorhanden.";
                    }
                    return null;
                });
                if (dlg.open() == 0) {
                    double zoomStufe = Double.valueOf(dlg.getValue());
                    int index = 0;
                    for (Double d : ((Darstellung)DarstellungZoomStufenSection.this.getElement()).getZoomStufen()) {
                        if (!(zoomStufe > d)) break;
                        ++index;
                    }
                    AddCommand cmd = new AddCommand(DarstellungZoomStufenSection.this.getElement(), (EStructuralFeature)DarstellungPackage.Literals.DARSTELLUNG__ZOOM_STUFEN, index, (Object)zoomStufe);
                    DarstellungZoomStufenSection.this.getCommandStack().execute((Command)cmd);
                }
            }
        });
        removeZoomStufeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DarstellungZoomStufenSection.this.zoomStufenViewer.getSelection();
                RemoveCommand cmd = new RemoveCommand(DarstellungZoomStufenSection.this.getElement(), (EStructuralFeature)DarstellungPackage.Literals.DARSTELLUNG__ZOOM_STUFEN, (Collection)selection.toList());
                DarstellungZoomStufenSection.this.getCommandStack().execute((Command)cmd);
            }
        });
        this.zoomStufenViewer.addSelectionChangedListener(event -> removeZoomStufeButton.setEnabled(!event.getSelection().isEmpty()));
    }

    private void createSkalierung(Composite parent) {
        TabbedPropertySheetWidgetFactory factory = this.getWidgetFactory();
        this.skalierungSpinner = new Spinner(parent, 2048);
        this.skalierungSpinner.setMinimum(1);
        this.skalierungSpinner.setMaximum(Integer.MAX_VALUE);
        this.skalierungSpinner.setDigits(3);
        this.skalierungSpinner.setIncrement(1000);
        this.skalierungSpinner.setPageIncrement(10000);
        factory.adapt(parent);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 170);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(this.zoomStufenViewer.getControl(), 4);
        this.skalierungSpinner.setLayoutData((Object)data);
        CLabel label = factory.createCLabel(parent, "Skalierung:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.skalierungSpinner, -5);
        data.top = new FormAttachment((Control)this.skalierungSpinner, 0, 0x1000000);
        label.setLayoutData((Object)data);
        this.skalierungSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double value = DarstellungZoomStufenSection.this.skalierungSpinner.getSelection();
                SetCommand cmd = new SetCommand(DarstellungZoomStufenSection.this.getElement(), (EStructuralFeature)DarstellungPackage.Literals.DARSTELLUNG__ZOOM_SKALIERUNG, (Object)(value /= Math.pow(10.0, DarstellungZoomStufenSection.this.skalierungSpinner.getDigits())));
                DarstellungZoomStufenSection.this.getCommandStack().execute((Command)cmd);
            }
        });
    }

    public void refresh() {
        this.zoomStufenViewer.setInput((Object)((Darstellung)this.getElement()).getZoomStufen());
        Double zoomSkalierung = ((Darstellung)this.getElement()).getZoomSkalierung() * Math.pow(10.0, this.skalierungSpinner.getDigits());
        if (zoomSkalierung.intValue() != this.skalierungSpinner.getSelection()) {
            this.skalierungSpinner.setSelection(zoomSkalierung.intValue());
        }
    }
}

