/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.tools;

import de.bsvrz.buv.plugin.darstellung.commands.CreateDoModelCommand;
import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.model.Ebene;
import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.tools.AbstractDragTool;
import de.bsvrz.buv.plugin.dopositionierer.wizards.AufreihenWizard;
import java.util.List;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AufreihenTool
extends AbstractDragTool {
    private Figure feedbackFigure;
    private AufreihenWizard wizard;

    private Point getEndPoint() {
        Point p1 = this.getStartLocation();
        Point p2 = this.getLocation();
        if (Math.abs(p2.x - p1.x) < Math.abs(p2.y - p1.y)) {
            p2.x = p1.x;
        } else {
            p2.y = p1.y;
        }
        return p2;
    }

    public AufreihenTool() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    protected String getCommandName() {
        return "Systemobjekte aufreihen";
    }

    public void activate() {
        super.activate();
        if (this.wizard == null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            this.wizard = new AufreihenWizard();
            WizardDialog dlg = new WizardDialog(shell, (IWizard)this.wizard);
            dlg.create();
            dlg.getShell().setSize(640, 480);
            if (dlg.open() != 0) {
                this.wizard = null;
            }
        }
    }

    protected boolean handleButtonDown(int button) {
        if (button != 1) {
            return false;
        }
        return super.handleButtonDown(button);
    }

    protected void handleFinished() {
        if (this.wizard == null) {
            return;
        }
        List<DoModel> doObjekte = this.wizard.getObjekte(this.getStartLocation(), this.getEndPoint());
        Darstellung darstellung = (Darstellung)this.getCurrentViewer().getProperty(Darstellung.class.toString());
        Ebene ebene = null;
        for (Ebene e : darstellung.getEbenen()) {
            if (!e.isEditable()) continue;
            ebene = e;
            break;
        }
        if (ebene != null) {
            CompoundCommand command = new CompoundCommand("Systemobjekte aufreihen");
            for (DoModel model : doObjekte) {
                command.add((Command)new CreateDoModelCommand(model, ebene));
            }
            this.getCurrentViewer().getEditDomain().getCommandStack().execute((Command)command);
        } else {
            MessageDialog.openInformation(null, (String)"Aktion nicht ausf\u00fchrbar", (String)"Es ist keine Ebene zum Bearbeiten markiert. Markieren Sie eine Ebene zum Bearbeiten und f\u00fchren Sie die Aktion noch einmal durch.");
        }
        super.handleFinished();
    }

    private Rectangle getSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    private IFigure getFeedbackFigure() {
        if (this.feedbackFigure == null) {
            this.feedbackFigure = new FeedbackFigure();
            this.addFeedback((IFigure)this.feedbackFigure);
        }
        return this.feedbackFigure;
    }

    protected void showFeedback() {
        Rectangle rect = this.getSelectionRectangle().getCopy();
        this.getFeedbackFigure().translateToRelative((Translatable)rect);
        this.getFeedbackFigure().setBounds(rect);
    }

    protected void eraseFeedback() {
        if (this.feedbackFigure != null) {
            this.removeFeedback((IFigure)this.feedbackFigure);
            this.feedbackFigure = null;
        }
    }

    private class FeedbackFigure
    extends Figure {
        private FeedbackFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            graphics.setLineStyle(3);
            Point p1 = AufreihenTool.this.getStartLocation();
            Point p2 = AufreihenTool.this.getEndPoint();
            if (Math.abs(p2.x - p1.x) < Math.abs(p2.y - p1.y)) {
                p2.x = p1.x;
            } else {
                p2.y = p1.y;
            }
            graphics.drawLine(p1, p2);
        }
    }
}

