/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import de.bsvrz.buv.plugin.dobj.model.DoModel;
import de.bsvrz.buv.plugin.dobj.model.DoTyp;
import de.bsvrz.buv.plugin.dopositionierer.util.BetriebsKilometerComparator;
import de.bsvrz.buv.plugin.dopositionierer.util.HochwertComparator;
import de.bsvrz.buv.plugin.dopositionierer.util.PunktSortierung;
import de.bsvrz.buv.plugin.dopositionierer.util.RechtswertComparator;
import de.bsvrz.buv.plugin.dopositionierer.wizards.AufreihenOptionsWizardPage;
import de.bsvrz.buv.plugin.dopositionierer.wizards.DoTypWizardPage;
import de.bsvrz.buv.plugin.dopositionierer.wizards.StrassenSegmentWizardPage;
import de.bsvrz.buv.plugin.dopositionierer.wizards.SystemObjectsWizardPage;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.modell.SystemObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.Punkt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktLiegtAufLinienObjekt;
import de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY;
import de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.StrassenSegment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class AufreihenWizard
extends Wizard
implements PropertyChangeListener {
    private AufreihenOptionsWizardPage aufreihenOptionsPage;
    private DoTypWizardPage doTypPage;
    private StrassenSegmentWizardPage strassenSegmentPage;
    private SystemObjectsWizardPage systemObjectsPage;

    public void addPages() {
        this.aufreihenOptionsPage = new AufreihenOptionsWizardPage("aufreihenOptionsPage");
        this.addPage((IWizardPage)this.aufreihenOptionsPage);
        this.doTypPage = new DoTypWizardPage("doTypPage");
        this.addPage((IWizardPage)this.doTypPage);
        this.strassenSegmentPage = new StrassenSegmentWizardPage("strassenSegmentPage");
        this.addPage((IWizardPage)this.strassenSegmentPage);
        this.systemObjectsPage = new SystemObjectsWizardPage("systemObjectPage");
        this.addPage((IWizardPage)this.systemObjectsPage);
        this.aufreihenOptionsPage.addPropertyChangeListener(this);
        this.doTypPage.addPropertyChangeListener(this);
        this.strassenSegmentPage.addPropertyChangeListener(this);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.doTypPage && this.aufreihenOptionsPage.getSortierung() != PunktSortierung.Betriebskilometer) {
            return this.systemObjectsPage;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.systemObjectsPage && this.aufreihenOptionsPage.getSortierung() != PunktSortierung.Betriebskilometer) {
            return this.doTypPage;
        }
        return super.getPreviousPage(page);
    }

    public boolean canFinish() {
        boolean result = true;
        result &= this.aufreihenOptionsPage.isPageComplete();
        result &= this.doTypPage.isPageComplete();
        if (this.aufreihenOptionsPage.getSortierung() == PunktSortierung.Betriebskilometer) {
            result &= this.strassenSegmentPage.isPageComplete();
        }
        return result &= this.systemObjectsPage.isPageComplete();
    }

    public void dispose() {
        if (this.aufreihenOptionsPage != null) {
            this.aufreihenOptionsPage.removePropertyChangeListener(this);
        }
        if (this.doTypPage != null) {
            this.doTypPage.removePropertyChangeListener(this);
        }
        if (this.strassenSegmentPage != null) {
            this.strassenSegmentPage.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    public boolean performFinish() {
        return true;
    }

    public DoTyp getDoTyp() {
        return this.doTypPage.getDoTyp();
    }

    public Set<SystemObjekt> getSystemObjekte() {
        return this.systemObjectsPage.getSystemObjekte();
    }

    public List<DoModel> getObjekte(Point start, Point end) {
        ArrayList<Punkt> objekte = new ArrayList<Punkt>();
        for (SystemObjekt so : this.getSystemObjekte()) {
            objekte.add((Punkt)so);
        }
        switch (this.aufreihenOptionsPage.getSortierung()) {
            case Hochwert: {
                Collections.sort(objekte, new HochwertComparator());
                break;
            }
            case Rechtswert: {
                Collections.sort(objekte, new RechtswertComparator());
                break;
            }
            case Betriebskilometer: {
                Collections.sort(objekte, new BetriebsKilometerComparator());
            }
        }
        if (!this.aufreihenOptionsPage.isImVerhaeltnis()) {
            return this.aufreihenGleichmaessig(start, end, objekte);
        }
        if (this.aufreihenOptionsPage.getSortierung() == PunktSortierung.Betriebskilometer) {
            return this.aufreihenImVerhaeltnisOffset(start, end, objekte);
        }
        return this.aufreihenImVerhaeltnisXY(start, end, objekte);
    }

    private List<DoModel> aufreihenImVerhaeltnisXY(Point start, Point end, List<Punkt> objekte) {
        double abstand;
        int linienlaenge;
        boolean horizontal;
        DoTyp doTyp = this.getDoTyp();
        KdPunktKoordinaten.Daten wgs84Start = (KdPunktKoordinaten.Daten)((PunktXY)objekte.get(0)).getKdPunktKoordinaten().getDatum();
        KdPunktKoordinaten.Daten wgs84End = (KdPunktKoordinaten.Daten)((PunktXY)objekte.get(objekte.size() - 1)).getKdPunktKoordinaten().getDatum();
        boolean bl = horizontal = start.y == end.y;
        if (horizontal) {
            linienlaenge = end.x - start.x;
            abstand = (Double)wgs84End.getX().getValue() - (Double)wgs84Start.getX().getValue();
        } else {
            linienlaenge = end.y - start.y;
            abstand = (Double)wgs84End.getY().getValue() - (Double)wgs84Start.getY().getValue();
        }
        ArrayList<DoModel> doObjekte = new ArrayList<DoModel>();
        int i = 0;
        while (i < objekte.size()) {
            SystemObjekt so = (SystemObjekt)objekte.get(i);
            DoModel doModel = doTyp.createModel();
            doModel.setSystemObject(so.getSystemObject());
            KdPunktKoordinaten.Daten wgs84 = (KdPunktKoordinaten.Daten)((PunktXY)objekte.get(i)).getKdPunktKoordinaten().getDatum();
            if (horizontal) {
                double dx = (Double)wgs84.getX().getValue() - (Double)wgs84Start.getX().getValue();
                m = (int)(dx / abstand * (double)linienlaenge);
                doModel.setLocation(new Point(start.x + m, start.y));
            } else {
                double dy = (Double)wgs84.getY().getValue() - (Double)wgs84Start.getY().getValue();
                m = (int)(dy / abstand * (double)linienlaenge);
                doModel.setLocation(new Point(start.x, start.y + m));
            }
            doObjekte.add(doModel);
            ++i;
        }
        return doObjekte;
    }

    private List<DoModel> aufreihenImVerhaeltnisOffset(Point start, Point end, List<Punkt> objekte) {
        DoTyp doTyp = this.getDoTyp();
        KdPunktLiegtAufLinienObjekt.Daten offsetStart = (KdPunktLiegtAufLinienObjekt.Daten)((PunktLiegtAufLinienObjekt)objekte.get(0)).getKdPunktLiegtAufLinienObjekt().getDatum();
        KdPunktLiegtAufLinienObjekt.Daten offsetEnd = (KdPunktLiegtAufLinienObjekt.Daten)((PunktLiegtAufLinienObjekt)objekte.get(objekte.size() - 1)).getKdPunktLiegtAufLinienObjekt().getDatum();
        boolean horizontal = start.y == end.y;
        int linienlaenge = horizontal ? end.x - start.x : end.y - start.y;
        double abstand = (Double)offsetEnd.getOffset().getValue() - (Double)offsetStart.getOffset().getValue();
        ArrayList<DoModel> doObjekte = new ArrayList<DoModel>();
        int i = 0;
        while (i < objekte.size()) {
            SystemObjekt so = (SystemObjekt)objekte.get(i);
            DoModel doModel = doTyp.createModel();
            doModel.setSystemObject(so.getSystemObject());
            KdPunktLiegtAufLinienObjekt.Daten offset = (KdPunktLiegtAufLinienObjekt.Daten)((PunktLiegtAufLinienObjekt)objekte.get(i)).getKdPunktLiegtAufLinienObjekt().getDatum();
            if (horizontal) {
                double dx = (Double)offset.getOffset().getValue() - (Double)offsetStart.getOffset().getValue();
                m = (int)(dx / abstand * (double)linienlaenge);
                doModel.setLocation(new Point(start.x + m, start.y));
            } else {
                double dy = (Double)offset.getOffset().getValue() - (Double)offsetStart.getOffset().getValue();
                m = (int)(dy / abstand * (double)linienlaenge);
                doModel.setLocation(new Point(start.x, start.y + m));
            }
            doObjekte.add(doModel);
            ++i;
        }
        return doObjekte;
    }

    private List<DoModel> aufreihenGleichmaessig(Point start, Point end, List<Punkt> objekte) {
        DoTyp doTyp = this.getDoTyp();
        boolean horizontal = start.y == end.y;
        int offset = horizontal ? (end.x - start.x) / (objekte.size() - 1) : (end.y - start.y) / (objekte.size() - 1);
        ArrayList<DoModel> doObjekte = new ArrayList<DoModel>();
        int i = 0;
        while (i < objekte.size()) {
            SystemObjekt so = (SystemObjekt)objekte.get(i);
            DoModel doModel = doTyp.createModel();
            doModel.setSystemObject(so.getSystemObject());
            if (horizontal) {
                doModel.setLocation(new Point(start.x + i * offset, start.y));
            } else {
                doModel.setLocation(new Point(start.x, start.y + i * offset));
            }
            doObjekte.add(doModel);
            ++i;
        }
        return doObjekte;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("systemObjectType".equals(prop)) {
            SystemObjectType type = (SystemObjectType)evt.getNewValue();
            this.doTypPage.setSystemObjectType(type);
        } else if ("doTyp".equals(prop)) {
            DoTyp doTyp = (DoTyp)evt.getNewValue();
            if (doTyp != null) {
                this.systemObjectsPage.setSystemObjectType(doTyp.getSystemObjectType());
            } else {
                this.systemObjectsPage.setSystemObjectType(null);
            }
        } else if ("strassenSegment".equals(prop)) {
            StrassenSegment ss = (StrassenSegment)evt.getNewValue();
            this.systemObjectsPage.setStrassenSegment(ss);
        }
    }
}

