/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.darstellung.util.DarstellungenEinstellungen;
import de.bsvrz.buv.plugin.dopositionierer.editors.DarstellungEditorInput;
import de.bsvrz.buv.plugin.dopositionierer.internal.DarstellungsTyp;
import de.bsvrz.buv.plugin.dopositionierer.wizards.NewDarstellungWizardPage;
import de.bsvrz.buv.rw.basislib.einstellungen.SpeicherKey;
import de.bsvrz.buv.rw.basislib.einstellungen.UrlasserDialogAbgebrochenException;
import de.bsvrz.buv.rw.bitctrl.eclipse.wizards.EinstellungsArtWizardPage;
import java.io.IOException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class NewDarstellungWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = NewDarstellungWizard.class.getName();
    private IWorkbench workbench;
    private NewDarstellungWizardPage darstellungPage;
    private EinstellungsArtWizardPage einstellungsArtWizardPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
    }

    public void addPages() {
        this.darstellungPage = new NewDarstellungWizardPage(NewDarstellungWizardPage.class.getName());
        this.addPage((IWizardPage)this.darstellungPage);
        this.einstellungsArtWizardPage = new EinstellungsArtWizardPage(EinstellungsArtWizardPage.class.getName());
        this.addPage((IWizardPage)this.einstellungsArtWizardPage);
    }

    public boolean performFinish() {
        SpeicherKey einstellungsArt;
        Darstellung darstellung = this.darstellungPage.getDarstellung();
        if (this.exists(darstellung, einstellungsArt = this.einstellungsArtWizardPage.getFirstEinstellungsArt()) && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"Darstellung existiert bereits", (String)("Es gibt bereits eine Darstellung mit dem Namen \"" + darstellung.getName() + "\" im Einstellungsspeicher der Art \n" + String.valueOf(einstellungsArt) + "\".\n\nSoll diese Darstellung \u00fcberschrieben werden."))) {
            return false;
        }
        try {
            DarstellungenEinstellungen.INSTANCE.setModellEinstellungen(einstellungsArt, darstellung.getName(), (EObject)darstellung);
            DarstellungEditorInput input = new DarstellungEditorInput(darstellung, einstellungsArt);
            input.setExists(true);
            DarstellungsTyp.openEditor((IEditorInput)input);
            return true;
        }
        catch (UrlasserDialogAbgebrochenException input) {
        }
        catch (IOException ex) {
            ErrorDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"FEHLER", (String)"Darstellung konnte nicht angelegt werden!", (IStatus)new Status(4, "de.bsvrz.buv.plugin.dopositionierer", ex.getLocalizedMessage(), (Throwable)ex));
        }
        return false;
    }

    private boolean exists(Darstellung darstellung, SpeicherKey einstellungsArt) {
        return DarstellungenEinstellungen.INSTANCE.getModellEinstellungen(einstellungsArt, darstellung.getName()) != null;
    }
}

