/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.buv.plugin.dopositionierer.wizards;

import de.bsvrz.buv.plugin.darstellung.model.Darstellung;
import de.bsvrz.buv.plugin.dopositionierer.internal.DarstellungsTyp;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewDarstellungWizardPage
extends WizardPage {
    private Text name;
    private ListViewer darstellungsArt;

    public NewDarstellungWizardPage(String pageName) {
        super(pageName);
        this.setTitle("Neue Darstellung");
        this.setDescription("Bitte geben Sie den Namen und die Art der neuen Darstellung an.");
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(container, 0);
        label.setText("Name");
        this.name = new Text(container, 2048);
        this.name.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        label = new Label(container, 0);
        label.setText("Art der Darstellung");
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(16384, 128).create());
        this.darstellungsArt = new ListViewer(container, 2820);
        this.darstellungsArt.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.darstellungsArt.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.darstellungsArt.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.darstellungsArt.setInput((Object)DarstellungsTyp.values());
        this.darstellungsArt.setSelection((ISelection)new StructuredSelection((Object)DarstellungsTyp.values()[0]));
        this.hookListeners();
        this.name.setFocus();
        this.setControl((Control)container);
    }

    private void hookListeners() {
        this.name.addModifyListener(e -> this.updatePageComplete());
        this.darstellungsArt.addSelectionChangedListener(event -> this.updatePageComplete());
    }

    private void updatePageComplete() {
        boolean complete = true;
        complete &= !this.name.getText().isEmpty();
        this.setPageComplete(complete &= !this.darstellungsArt.getSelection().isEmpty());
    }

    public Darstellung getDarstellung() {
        IStructuredSelection selection = (IStructuredSelection)this.darstellungsArt.getSelection();
        DarstellungsTyp typ = (DarstellungsTyp)((Object)selection.getFirstElement());
        Darstellung darstellung = typ.create();
        darstellung.setName(this.name.getText());
        return darstellung;
    }
}

