/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Widget;

import com.bitctrl.lib.eclipse.databinding.observables.ObservablesUtil;
import com.bitctrl.lib.eclipse.databinding.provider.EnumIconDecorator;

import de.bsvrz.buv.plugin.pua.ganglinien.model.AxisProperties;
import de.bsvrz.buv.plugin.pua.ganglinien.model.observables.AxisPropertiesOL;

/**
 * Dekoriert Achsen mit einem Icon, das die Seite der Achse anzeigt.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
final class AxesTableLabelProvider extends EnumIconDecorator {
	/**
	 * Der eigentliche Dekorator.
	 *
	 * @author BitCtrl Systems GmbH, Enrico Schnepel
	 *
	 */
	private static final class AxisSideIconDecorator extends EnumIconLabelDecorator {
		/**
		 * Konstruktor.
		 *
		 * @param widget ein Widget, bei dessen {@link Widget#dispose() Zerstörung} das
		 *               Bild wieder freigegeben wird.
		 */
		private AxisSideIconDecorator(final Widget widget) {
			super(widget);
		}

		@Override
		public Image decorateImage(final Image image, final Object element) {
			return super.decorateImage(image, ((AxisProperties) element).getAxisSide());
		}
	}

	/**
	 * Jede Änderung an den Achseneinstellungen wird an den Labelprovider
	 * weitergereicht.
	 *
	 * @author BitCtrl Systems GmbH, Enrico Schnepel
	 *
	 */
	private final class LabelDecoratorUpdater implements IMapChangeListener {
		@Override
		public void handleMapChange(final MapChangeEvent event) {
			final List<?> keys = new ArrayList<>();
			keys.addAll(event.diff.getAddedKeys());
			keys.addAll(event.diff.getChangedKeys());
			keys.addAll(event.diff.getRemovedKeys());
			fireLabelProviderChanged(new LabelProviderChangedEvent(getLabelProvider(), keys.toArray()));
		}
	}

	/**
	 * Konstruktor.
	 *
	 * @param axes   die Liste der Achsen
	 * @param widget ein Widget, auf dessen {@link Widget#dispose() Zerstörung}
	 *               gewartet wird.
	 */
	AxesTableLabelProvider(final AxisPropertiesOL axes, final Widget widget) {
		super(new ObservableMapLabelProvider(axes.getTitle()), new AxisSideIconDecorator(widget));
		ObservablesUtil.addAndDisposeListener(widget, new LabelDecoratorUpdater(), axes.getAxisSide());
	}
}
