/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import org.eclipse.swt.graphics.RGB;

/**
 * Hilfsklasse zum Verarbeitun von SWT-{@link RGB}-Objekten.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public final class ColorHelper {

	/**
	 * Konstruktor.
	 */
	private ColorHelper() {
	}

	/**
	 * Verdunkelt um 50%.
	 *
	 * @param rgb Eingabe-Farbe
	 * @return dunklere Farbe
	 */
	public static RGB darker(final RGB rgb) {
		return new RGB(rgb.red / 2, rgb.green / 2, rgb.blue / 2);
	}

	/**
	 * Erhellt um 50%.
	 *
	 * @param rgb Eingabe-Farbe
	 * @return dunklere Farbe
	 */
	public static RGB lighter(final RGB rgb) {
		return new RGB(255 - (255 - rgb.red) / 2, 255 - (255 - rgb.green) / 2, 255 - (255 - rgb.blue) / 2);
	}

	/**
	 * Mischt zwei Farben zu gleichen Anteilen.
	 *
	 * @param rgb1 Farbe 1
	 * @param rgb2 Farbe 2
	 * @return die gemischte Farbe
	 */
	public static RGB merge(final RGB rgb1, final RGB rgb2) {
		return new RGB((rgb1.red + rgb2.red) / 2, (rgb1.green + rgb2.green) / 2, (rgb1.blue + rgb2.blue) / 2);
	}

	/**
	 * Ermittelt den Grauwert einer Farbe.
	 *
	 * @param rgb die Farbe
	 * @return der Grauwert
	 */
	public static int greyValue(final RGB rgb) {
		return (rgb.red * 30 + rgb.green * 59 + rgb.blue * 11) / 100;
	}

}
