/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;

import com.bitctrl.lib.eclipse.actions.AbstractCopyTableAction;

/**
 * Kopiert den Inhalt der Matrix in die Zwischenablage.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public class CopyGridAction extends AbstractCopyTableAction {

	/**
	 * Das Grid, das kopiert werde soll.
	 */
	private final Grid grid;

	/**
	 * Konstruktor.
	 *
	 * @param grid das Grid, welches kopiert werden kann
	 */
	public CopyGridAction(final Grid grid) {
		this.grid = grid;
		setToolTipText("Kopiert die selektierten Zeilen in der Tabelle");
	}

	@Override
	public void run() {
		if (grid != null && !grid.isDisposed()) {
			setClipboardContent(grid.getDisplay());
		}
	}

	@Override
	protected String getTextForSelection(final MainTag main) {
		final StringBuilder text = new StringBuilder();
		text.append(main.getBegin());
		text.append(main.head.getBegin());
		final GridColumnGroup[] columnGroups = grid.getColumnGroups();
		if (null != columnGroups && columnGroups.length > 0) {
			text.append(main.head.row.getBegin());
			if (grid.isRowHeaderVisible()) {
				text.append(main.head.row.data.getBegin());
				text.append(main.head.row.data.getEnd());
			}
			for (final GridColumnGroup group : columnGroups) {
				final int cols = group.getColumns().length;
				text.append(main.head.row.data.getBeginColspan(cols));
				final String content = group.getText();
				text.append(main.mask(content));
				text.append(main.head.row.data.getEndColspan(cols));
			}
			text.append(main.head.row.getEnd());
		}
		final GridColumn[] columns = grid.getColumns();
		text.append(main.head.row.getBegin());
		if (grid.isRowHeaderVisible()) {
			text.append(main.head.row.data.getBegin());
			text.append(main.head.row.data.getEnd());
		}
		for (final GridColumn column : columns) {
			text.append(main.head.row.data.getBegin());
			final String content = column.getText();
			text.append(main.mask(content));
			text.append(main.head.row.data.getEnd());
		}
		text.append(main.head.row.getEnd());
		text.append(main.head.getEnd());

		text.append(main.body.getBegin());
		GridItem[] rows = grid.getSelection();
		if (null == rows || 0 == rows.length) {
			rows = grid.getItems();
		}
		for (final GridItem row2 : rows) {
			text.append(main.body.row.getBegin());

			if (grid.isRowHeaderVisible()) {
				text.append(main.head.row.data.getBegin());
				text.append(main.mask(row2.getHeaderText()));
				text.append(main.head.row.data.getEnd());
			}
			for (int col = 0; col < columns.length; col++) {
				text.append(main.body.row.data.getBegin());
				final String content = row2.getText(col);
				text.append(main.mask(content));
				text.append(main.body.row.data.getEnd());
			}
			text.append(main.body.row.getEnd());
		}
		text.append(main.body.getEnd());
		text.append(main.getEnd());

		return text.toString();
	}
}
