/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

import com.bitctrl.lib.eclipse.actions.CopyAction;

/**
 * Kopiert die aktuell angezeigte Grafik in die Zwischenablage.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public class CopyPuaChartAction extends CopyAction {
	private final int xRes;
	private final int yRes;
	private final GanglinienChartBuilder ganglinienChartBuilder;

	public CopyPuaChartAction(final GanglinienChartBuilder ganglinienChartBuilder, final int xRes, final int yRes) {
		this.xRes = xRes;
		this.yRes = yRes;
		this.ganglinienChartBuilder = ganglinienChartBuilder;
		setToolTipText("Diagramm als Bild kopieren");
	}

	@Override
	public void runWithEvent(final Event event) {
		final Display current = Display.getCurrent();
		final Clipboard clipboard = new Clipboard(current);
		try {
			// Initialize.
			final PlatformConfig config = new PlatformConfig();
			config.setProperty("STANDALONE", "true"); //$NON-NLS-1$ //$NON-NLS-2$
			final IDeviceRenderer render = ChartEngine.instance(config).getRenderer("dv.BMP");//$NON-NLS-1$
			final Generator gr = Generator.instance();

			final Point dpi = current.getDPI();
			ganglinienChartBuilder.build();
			final GeneratedChartState state = gr.build(render.getDisplayServer(), ganglinienChartBuilder.getChart(),
					BoundsImpl.create(0, 0, xRes * 72 / dpi.x, yRes * 72 / dpi.y), null, null, null);
			// Render
			final ByteArrayOutputStream baos = new ByteArrayOutputStream();
			final BufferedOutputStream bos = new BufferedOutputStream(baos);

			render.setProperty("output.format", "BMP"); //$NON-NLS-1$ //$NON-NLS-2$
			render.setProperty(IDeviceRenderer.FILE_IDENTIFIER, bos);

			gr.render(render, state);

			// Get image from stream.
			final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
			final Image image = new Image(current, bais);
			final ImageData data = image.getImageData();
			clipboard.setContents(new Object[] { data }, new Transfer[] { ImageTransfer.getInstance() });
		} catch (final ChartException e) {
			e.printStackTrace();
		}
	}
}
