/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import java.util.ResourceBundle;

/**
 * Dynamische Schnittstelle zum Auslesen des ResourcenBundles.
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public final class DynamicMessages {
	/**
	 * das RessourcenBundle.
	 */
	private static final ResourceBundle BUNDLE = ResourceBundle
			.getBundle("de.bsvrz.buv.plugin.pua.ganglinien.messages.messages");
	/**
	 * Zugriffsklasse auf das Bundle.
	 */
	private static final com.bitctrl.messages.DynamicMessages INSTANCE = com.bitctrl.messages.DynamicMessages
			.getInstance(BUNDLE);

	/**
	 * Konstruktor.
	 */
	private DynamicMessages() {
	}

	/**
	 * Umgibt einen String mit Kommas (,).
	 *
	 * @see com.bitctrl.messages.DynamicMessages#encloseWithCommas(String)
	 * @param str z.B. "String"
	 * @return z.B. ",String,"
	 */
	public static String encloseWithCommas(final String str) {
		return INSTANCE.encloseWithCommas(str);
	}

	/**
	 * Ermittelt aus dem Bundle eine Übersetzung.
	 *
	 * @see com.bitctrl.messages.DynamicMessages#getString(String)
	 * @param key der Schlüssel
	 * @return die Übersetzung oder "!Schlüssel!" wenn der Schlüssel nicht
	 *         existiert.
	 */
	public static String getString(final String key) {
		return INSTANCE.getString(key);
	}

	/**
	 * Ermittelt aus dem Bundle eine Übersetzung oder null, wenn der Schlüssel nicht
	 * existiert.
	 *
	 * @see com.bitctrl.messages.DynamicMessages#getStringOrNull(String)
	 * @param key der Schlüssel
	 * @return die Übersetzung
	 */
	public static String getStringOrNull(final String key) {
		return INSTANCE.getStringOrNull(key);
	}

	/**
	 * gibt das Ressourcen-Bundle zurück, auf dem gearbeitet wird.
	 *
	 * @return das Bundle
	 */
	public static ResourceBundle getBundle() {
		return BUNDLE;
	}

}
