/*
 * Rahmenwerk-Plug-in "Protokolle und Auswertungen"
 * Copyright (C) 2018 BitCtrl Systems GmbH
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 51
 * Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weissenfelser Strasse 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */
package de.bsvrz.buv.plugin.pua.ganglinien;

import org.eclipse.swt.graphics.Image;

import de.bsvrz.buv.plugin.pua.ganglinien.MatrixGrid.MatrixLabelProvider;

/**
 * Stellt eine nicht gefuellte Zelle dar. Wird verwendet, um eine Zelle manuell
 * zu zeichnen.
 *
 * @param <R> "Row" - der Typ der Zeilenobjekte
 * @param <C> "Column" - der Typ der Spaltenobjekte
 * @param <D> "Data" - der Typ der Datenobjekte
 *
 * @author BitCtrl Systems GmbH, Enrico Schnepel
 *
 */
public final class EmptyLabelProvider<R, C, D> extends MatrixLabelProvider<R, C, D> {
	/**
	 * Konstruktor.
	 *
	 * @param grid das {@link MatrixGrid}
	 */
	public EmptyLabelProvider(final MatrixGrid<R, C, D> grid) {
		super(grid);
	}

	@Override
	protected Image getCellImage(final R row, final C column, final D element) {
		return null;
	}

	@Override
	protected String getCellText(final R row, final C column, final D element) {
		return "";
	}
}
